/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.base;

import icbm.classic.api.EnumTier;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.caps.IMissileHolder;
import icbm.classic.api.caps.IMissileLauncher;
import icbm.classic.api.events.LauncherEvent;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.api.tile.multiblock.IMultiTile;
import icbm.classic.api.tile.multiblock.IMultiTileHost;
import icbm.classic.config.ConfigLauncher;
import icbm.classic.content.blocks.launcher.frame.TileLauncherFrame;
import icbm.classic.content.blocks.launcher.screen.TileLauncherScreen;
import icbm.classic.content.blocks.multiblock.MultiBlockHelper;
import icbm.classic.content.entity.EntityPlayerSeat;
import icbm.classic.content.entity.missile.EntityMissile;
import icbm.classic.content.items.ItemMissile;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.transform.rotation.EulerAngle;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.inventory.ExternalInventory;
import icbm.classic.prefab.inventory.IInventoryProvider;
import icbm.classic.prefab.tile.BlockICBM;
import icbm.classic.prefab.tile.TileMachine;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileLauncherBase
extends TileMachine
implements IMultiTileHost,
IInventoryProvider<ExternalInventory> {
    public static List<BlockPos> northSouthMultiBlockCache = new ArrayList<BlockPos>();
    public static List<BlockPos> eastWestMultiBlockCache = new ArrayList<BlockPos>();
    private static EulerAngle angle = new EulerAngle(0.0, 0.0, 0.0);
    public TileLauncherFrame supportFrame = null;
    public TileLauncherScreen launchScreen = null;
    public EntityPlayerSeat seat;
    private boolean _destroyingStructure = false;
    ExternalInventory inventory;
    public ItemStack cachedMissileStack;
    public final IMissileHolder missileHolder = null;
    public final IMissileLauncher missileLauncher = null;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer() && this.ticks % 3 == 0) {
            if (this.seat != null) {
                this.seat.func_70107_b(this.x() + 0.5, this.y() + 0.5, this.z() + 0.5);
            }
            if (!this.getMissileStack().func_190926_b() && this.seat == null) {
                this.seat = new EntityPlayerSeat(this.field_145850_b);
                this.seat.host = this;
                this.seat.rideOffset = (Pos)new Pos(this.getRotation()).multiply(0.5, 1.0, 0.5);
                this.seat.func_70107_b(this.x() + 0.5, this.y() + 0.5, this.z() + 0.5);
                this.seat.func_70105_a(0.5f, 2.5f);
                this.field_145850_b.func_72838_d((Entity)this.seat);
            } else if (this.getMissileStack().func_190926_b() && this.seat != null) {
                if (this.seat.func_184187_bx() != null) {
                    this.seat.func_184187_bx().func_184220_m(null);
                }
                this.seat.func_70106_y();
                this.seat = null;
            }
        }
        if (this.ticks % 20 == 0 && (this.supportFrame == null || this.launchScreen == null || this.launchScreen.func_145837_r() || this.supportFrame.func_145837_r())) {
            if (this.supportFrame != null) {
                this.supportFrame.launcherBase = null;
            }
            this.supportFrame = null;
            this.launchScreen = null;
            for (EnumFacing rotation : EnumFacing.field_176754_o) {
                Pos position = (Pos)new Pos(this.func_174877_v()).add(rotation);
                TileEntity tileEntity = this.field_145850_b.func_175625_s(position.toBlockPos());
                if (tileEntity instanceof TileLauncherFrame) {
                    this.supportFrame = (TileLauncherFrame)tileEntity;
                    this.supportFrame.launcherBase = this;
                    if (!this.isServer()) continue;
                    this.supportFrame.setRotation(this.getRotation());
                    continue;
                }
                if (!(tileEntity instanceof TileLauncherScreen)) continue;
                this.launchScreen = (TileLauncherScreen)tileEntity;
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getInventory() != null;
        }
        if (this.launchScreen != null) {
            return this.launchScreen.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.getInventory().itemHandlerWrapper;
        }
        if (this.launchScreen != null) {
            return this.launchScreen.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        if (slot == 0) {
            this.sendDescPacket();
        }
    }

    @Override
    public boolean canStore(ItemStack stack, EnumFacing side) {
        return stack != null && stack.func_77973_b() == ItemReg.itemMissile;
    }

    @Override
    public boolean canRemove(ItemStack stack, EnumFacing side) {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("gui.launcherBase.name", new Object[0]);
    }

    protected Pos applyInaccuracy(Pos target) {
        int inaccuracy = 30;
        if (this.supportFrame != null) {
            inaccuracy = this.supportFrame.getInaccuracy();
        }
        inaccuracy = this.func_145831_w().field_73012_v.nextInt(inaccuracy);
        angle.setYaw(this.func_145831_w().field_73012_v.nextFloat() * 360.0f);
        return (Pos)target.add(angle.x() * (double)inaccuracy, 0.0, angle.z() * (double)inaccuracy);
    }

    public boolean launchMissile(Pos target, int lockHeight) {
        IExplosiveData explosiveData;
        if (MinecraftForge.EVENT_BUS.post((Event)new LauncherEvent.PreLaunch(this.missileLauncher, this.missileHolder))) {
            return false;
        }
        ItemStack stack = this.getMissileStack();
        if (stack.func_77973_b() == ItemReg.itemMissile && (explosiveData = ICBMClassicHelpers.getExplosive(stack.func_77952_i(), true)) != null) {
            target = this.applyInaccuracy(target);
            if (this.isServer()) {
                EntityMissile missile = new EntityMissile(this.func_145831_w());
                missile.explosiveID = explosiveData.getRegistryID();
                missile.launcherPos = new Pos(this);
                missile.func_70107_b((double)this.xi() + 0.5, this.yi() + 3, (double)this.zi() + 0.5);
                missile.capabilityMissile.launch(target.x(), target.y(), target.z(), lockHeight);
                ((WorldServer)this.func_145831_w()).func_152344_a(() -> this.func_145831_w().func_72838_d((Entity)missile));
                if (this.seat != null && this.seat.func_184187_bx() != null) {
                    Entity entity = this.seat.func_184187_bx();
                    this.seat.func_184187_bx().func_184220_m(null);
                    entity.func_184220_m((Entity)missile);
                }
                this.getInventory().func_70298_a(0, 1);
            }
            return true;
        }
        return false;
    }

    public boolean isInRange(Pos target) {
        if (target != null) {
            return !this.isTargetTooFar(target) && !this.isTargetTooClose(target);
        }
        return false;
    }

    public boolean isTargetTooClose(Pos target) {
        return new Pos(this.x(), 0.0, this.z()).distance(new Pos(target.x(), 0.0, target.z())) < 10.0;
    }

    public boolean isTargetTooFar(Pos target) {
        double distance = new Pos(this.x(), 0.0, this.z()).distance(new Pos(target.x(), 0.0, target.z()));
        return distance > this.getRange();
    }

    public double getRange() {
        return TileLauncherBase.getRangeForTier(this.getTier());
    }

    public static double getRangeForTier(EnumTier tier) {
        if (tier == EnumTier.ONE) {
            return ConfigLauncher.LAUNCHER_RANGE_TIER1;
        }
        if (tier == EnumTier.TWO) {
            return ConfigLauncher.LAUNCHER_RANGE_TIER2;
        }
        return ConfigLauncher.LAUNCHER_RANGE_TIER3;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getInventory().load(nbt.func_74775_l("inventory"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("inventory", (NBTBase)this.getInventory().save(new NBTTagCompound()));
        return super.func_189515_b(nbt);
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.getMissileStack());
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.cachedMissileStack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public ItemStack getMissileStack() {
        if (this.isClient() && this.cachedMissileStack != null) {
            return this.cachedMissileStack;
        }
        return this.getInventory().func_70301_a(0);
    }

    public boolean onPlayerRightClick(EntityPlayer player, EnumHand hand, ItemStack heldItem) {
        if (!this.tryInsertMissile(player, hand, heldItem) && this.launchScreen != null) {
            return BlockReg.blockLaunchScreen.func_180639_a(this.field_145850_b, this.launchScreen.func_174877_v(), this.field_145850_b.func_180495_p(this.launchScreen.func_174877_v()), player, hand, EnumFacing.NORTH, 0.0f, 0.0f, 0.0f);
        }
        return true;
    }

    public boolean tryInsertMissile(EntityPlayer player, EnumHand hand, ItemStack heldItem) {
        if (heldItem.func_77973_b() instanceof ItemMissile && this.getMissileStack().func_190926_b()) {
            if (heldItem.func_77973_b() instanceof ItemMissile && this.getMissileStack().func_190926_b()) {
                if (this.isServer()) {
                    this.getInventory().func_70299_a(0, heldItem);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                        player.field_71069_bz.func_75142_b();
                    }
                }
                return true;
            }
        } else if (player.func_70093_af() && heldItem.func_190926_b() && !this.getMissileStack().func_190926_b()) {
            if (this.isServer()) {
                player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, this.getMissileStack());
                this.getInventory().func_70299_a(0, ItemStack.field_190927_a);
                player.field_71069_bz.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public ExternalInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new ExternalInventory(this, 1);
        }
        return this.inventory;
    }

    @Override
    public boolean canStore(ItemStack stack, int slot, EnumFacing side) {
        return slot == 0 && stack.func_77973_b() instanceof ItemMissile;
    }

    @Override
    public void onMultiTileAdded(IMultiTile tileMulti) {
        if (tileMulti instanceof TileEntity) {
            BlockPos pos = ((TileEntity)tileMulti).func_174877_v().func_177973_b((Vec3i)this.func_174877_v());
            if (this.getLayoutOfMultiBlock().contains(pos)) {
                tileMulti.setHost(this);
            }
        }
    }

    @Override
    public boolean onMultiTileBroken(IMultiTile tileMulti, Object source, boolean harvest) {
        if (!this._destroyingStructure && tileMulti instanceof TileEntity) {
            BlockPos pos = ((TileEntity)tileMulti).func_174877_v().func_177973_b((Vec3i)this.func_174877_v());
            if (this.getLayoutOfMultiBlock().contains(pos)) {
                MultiBlockHelper.destroyMultiBlockStructure(this, harvest, true, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public void onTileInvalidate(IMultiTile tileMulti) {
    }

    @Override
    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, EnumHand hand, EnumFacing side, float xHit, float yHit, float zHit) {
        return this.onPlayerRightClick(player, hand, player.func_184586_b(hand));
    }

    @Override
    public void onMultiTileClicked(IMultiTile tile, EntityPlayer player) {
    }

    public List<BlockPos> getLayoutOfMultiBlock() {
        return TileLauncherBase.getLayoutOfMultiBlock(this.getRotation());
    }

    public static List<BlockPos> getLayoutOfMultiBlock(EnumFacing facing) {
        if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
            return eastWestMultiBlockCache;
        }
        return northSouthMultiBlockCache;
    }

    @Override
    public void setRotation(EnumFacing facingDirection) {
        if (facingDirection != this.getRotation() && facingDirection != EnumFacing.UP && facingDirection != EnumFacing.DOWN) {
            if (this.isServer()) {
                MultiBlockHelper.destroyMultiBlockStructure(this, false, true, false);
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, this.getBlockState().func_177226_a((IProperty)BlockICBM.ROTATION_PROP, (Comparable)facingDirection));
            if (this.isServer()) {
                MultiBlockHelper.buildMultiBlock(this.func_145831_w(), this, true, true);
                this.func_70296_d();
            }
        }
    }

    static {
        northSouthMultiBlockCache.add(new BlockPos(1, 0, 0));
        northSouthMultiBlockCache.add(new BlockPos(1, 1, 0));
        northSouthMultiBlockCache.add(new BlockPos(1, 2, 0));
        northSouthMultiBlockCache.add(new BlockPos(-1, 0, 0));
        northSouthMultiBlockCache.add(new BlockPos(-1, 1, 0));
        northSouthMultiBlockCache.add(new BlockPos(-1, 2, 0));
        eastWestMultiBlockCache.add(new BlockPos(0, 0, 1));
        eastWestMultiBlockCache.add(new BlockPos(0, 1, 1));
        eastWestMultiBlockCache.add(new BlockPos(0, 2, 1));
        eastWestMultiBlockCache.add(new BlockPos(0, 0, -1));
        eastWestMultiBlockCache.add(new BlockPos(0, 1, -1));
        eastWestMultiBlockCache.add(new BlockPos(0, 2, -1));
    }
}

