/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.screen;

import icbm.classic.ICBMClassic;
import icbm.classic.api.EnumTier;
import icbm.classic.api.items.IWorldPosItem;
import icbm.classic.config.ConfigLauncher;
import icbm.classic.content.blocks.launcher.screen.TileLauncherScreen;
import icbm.classic.content.items.ItemLaserDetonator;
import icbm.classic.content.items.ItemRemoteDetonator;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.transform.vector.Location;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.tile.BlockICBM;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLaunchScreen
extends BlockICBM {
    private static final float px = 0.0625f;
    private static final AxisAlignedBB ONE_TWO_NORTH = new AxisAlignedBB(0.1875, 0.0, 0.375, 0.8125, 0.59375, 0.671875);
    private static final AxisAlignedBB ONE_TWO_SOUTH = new AxisAlignedBB(0.8125, 0.0, 0.328125, 0.1875, 0.59375, 0.625);
    private static final AxisAlignedBB ONE_TWO_EAST = new AxisAlignedBB(0.328125, 0.0, 0.8125, 0.625, 0.59375, 0.1875);
    private static final AxisAlignedBB ONE_TWO_WEST = new AxisAlignedBB(0.375, 0.0, 0.1875, 0.671875, 0.59375, 0.8125);
    private static final AxisAlignedBB THREE_NORTH = new AxisAlignedBB(0.1875, 0.0, 0.125, 0.8125, 0.65625, 0.75);
    private static final AxisAlignedBB THREE_SOUTH = new AxisAlignedBB(0.8125, 0.0, 0.875, 0.1875, 0.65625, 0.25);
    private static final AxisAlignedBB THREE_EAST = new AxisAlignedBB(0.875, 0.0, 0.8125, 0.25, 0.65625, 0.1875);
    private static final AxisAlignedBB THREE_WEST = new AxisAlignedBB(0.125, 0.0, 0.1875, 0.75, 0.65625, 0.8125);

    public BlockLaunchScreen() {
        super("launcherscreen");
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177230_c() instanceof BlockLaunchScreen) {
            switch ((EnumTier)((Object)state.func_177229_b((IProperty)TIER_PROP))) {
                case ONE: 
                case TWO: {
                    switch ((EnumFacing)state.func_177229_b((IProperty)ROTATION_PROP)) {
                        case NORTH: {
                            return ONE_TWO_NORTH;
                        }
                        case SOUTH: {
                            return ONE_TWO_SOUTH;
                        }
                        case EAST: {
                            return ONE_TWO_EAST;
                        }
                        case WEST: {
                            return ONE_TWO_WEST;
                        }
                    }
                    return super.func_185496_a(state, source, pos);
                }
                case THREE: {
                    switch ((EnumFacing)state.func_177229_b((IProperty)ROTATION_PROP)) {
                        case NORTH: {
                            return THREE_NORTH;
                        }
                        case SOUTH: {
                            return THREE_SOUTH;
                        }
                        case EAST: {
                            return THREE_EAST;
                        }
                        case WEST: {
                            return THREE_WEST;
                        }
                    }
                    return super.func_185496_a(state, source, pos);
                }
            }
            return super.func_185496_a(state, source, pos);
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileLauncherScreen) {
            TileLauncherScreen screen = (TileLauncherScreen)tileEntity;
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() == Items.field_151137_ax) {
                if (screen._tier == EnumTier.ONE && !ConfigLauncher.LAUNCHER_REDSTONE_TIER1 || screen._tier == EnumTier.TWO && !ConfigLauncher.LAUNCHER_REDSTONE_TIER2 || screen._tier == EnumTier.THREE && !ConfigLauncher.LAUNCHER_REDSTONE_TIER3) {
                    return false;
                }
                if (!screen.launch()) {
                    player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.failedToFire")));
                    String translation = LanguageUtility.getLocal("chat.launcher.status");
                    translation = translation.replace("%s", screen.getStatus());
                    player.func_145747_a((ITextComponent)new TextComponentString(translation));
                }
            } else if (stack.func_77973_b() instanceof ItemRemoteDetonator) {
                ((ItemRemoteDetonator)stack.func_77973_b()).setBroadCastHz(stack, screen.getFrequency());
                player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.toolFrequencySet").replace("%s", "" + screen.getFrequency())));
            } else if (stack.func_77973_b() instanceof ItemLaserDetonator) {
                ((ItemLaserDetonator)stack.func_77973_b()).setBroadCastHz(stack, screen.getFrequency());
                player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.toolFrequencySet").replace("%s", "" + screen.getFrequency())));
            } else if (stack.func_77973_b() instanceof IWorldPosItem) {
                Location location = ((IWorldPosItem)stack.func_77973_b()).getLocation(stack);
                if (location != null) {
                    if (location.world() == world) {
                        screen.setTarget(new Pos(location.x(), location.y(), location.z()));
                        player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.toolTargetSet")));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.toolWorldNotMatch")));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.noTargetInTool")));
                }
            } else if (screen.launcherBase == null || !screen.launcherBase.tryInsertMissile(player, hand, player.func_184586_b(hand))) {
                player.openGui((Object)ICBMClassic.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileLauncherScreen && world.func_175640_z(pos)) {
            TileLauncherScreen screen = (TileLauncherScreen)tileEntity;
            if (screen._tier == EnumTier.ONE && !ConfigLauncher.LAUNCHER_REDSTONE_TIER1 || screen._tier == EnumTier.TWO && !ConfigLauncher.LAUNCHER_REDSTONE_TIER2 || screen._tier == EnumTier.THREE && !ConfigLauncher.LAUNCHER_REDSTONE_TIER3) {
                return;
            }
            screen.launch();
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileLauncherScreen();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumTier)((Object)state.func_177229_b((IProperty)TIER_PROP))).ordinal();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION_PROP, TIER_PROP});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumTier tier = EnumTier.ONE;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileLauncherScreen) {
            tier = ((TileLauncherScreen)tile)._tier;
        }
        return state.func_177226_a((IProperty)TIER_PROP, (Comparable)((Object)tier));
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        ItemStack stack = placer.func_184586_b(hand);
        return this.func_176223_P().func_177226_a((IProperty)TIER_PROP, (Comparable)((Object)EnumTier.get(stack.func_77952_i()))).func_177226_a((IProperty)ROTATION_PROP, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileLauncherScreen) {
            ((TileLauncherScreen)tile)._tier = EnumTier.get(stack.func_77952_i());
        }
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
        items.add((Object)new ItemStack((Block)this, 1, 2));
    }
}

