/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.screen;

import icbm.classic.ICBMClassic;
import icbm.classic.content.blocks.launcher.screen.ContainerLaunchScreen;
import icbm.classic.content.blocks.launcher.screen.TileLauncherScreen;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.network.packet.PacketTile;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.gui.GuiContainerBase;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiLauncherScreen
extends GuiContainerBase {
    public static final ResourceLocation TEXTURE = new ResourceLocation("icbmclassic", "textures/gui/gui_empty.png");
    private TileLauncherScreen tileEntity;
    private GuiTextField target_xCoord_field;
    private GuiTextField target_yCoord_field;
    private GuiTextField target_zCoord_field;
    private GuiTextField target_freq_field;
    private GuiTextField lock_height_field;
    private GuiButton launch_button;
    private int containerWidth;
    private int containerHeight;

    public GuiLauncherScreen(EntityPlayer player, TileLauncherScreen tileEntity) {
        super(new ContainerLaunchScreen(player, tileEntity));
        this.tileEntity = tileEntity;
        this.field_147000_g = 166;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.target_xCoord_field = new GuiTextField(0, this.field_146289_q, 110, 37, 45, 12);
        this.target_zCoord_field = new GuiTextField(1, this.field_146289_q, 110, 52, 45, 12);
        this.target_yCoord_field = new GuiTextField(2, this.field_146289_q, 110, 67, 45, 12);
        this.lock_height_field = new GuiTextField(3, this.field_146289_q, 110, 82, 45, 12);
        this.target_freq_field = new GuiTextField(5, this.field_146289_q, 110, 97, 45, 12);
        this.target_freq_field.func_146203_f(4);
        this.target_xCoord_field.func_146203_f(6);
        this.target_zCoord_field.func_146203_f(6);
        this.target_yCoord_field.func_146203_f(3);
        this.lock_height_field.func_146203_f(3);
        this.target_freq_field.func_146180_a(this.tileEntity.getFrequency() + "");
        this.lock_height_field.func_146180_a(this.tileEntity.lockHeight + "");
        this.launch_button = this.func_189646_b(new GuiButton(0, this.field_147003_i + this.field_146999_f / 2 - 55, this.field_147009_r + 140, 110, 20, LanguageUtility.getLocal("gui.launcherscreen.launch")));
        if (this.tileEntity.getTarget() == null) {
            this.target_xCoord_field.func_146180_a(Math.round(this.tileEntity.func_174877_v().func_177958_n()) + "");
            this.target_zCoord_field.func_146180_a(Math.round(this.tileEntity.func_174877_v().func_177952_p()) + "");
            this.target_yCoord_field.func_146180_a("0");
        } else {
            this.target_xCoord_field.func_146180_a(Math.round(this.tileEntity.getTarget().x()) + "");
            this.target_zCoord_field.func_146180_a(Math.round(this.tileEntity.getTarget().z()) + "");
            this.target_yCoord_field.func_146180_a(Math.round(this.tileEntity.getTarget().y()) + "");
        }
    }

    @Override
    public void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        this.target_xCoord_field.func_146201_a(par1, par2);
        this.target_zCoord_field.func_146201_a(par1, par2);
        if (this.tileEntity.getTier().ordinal() >= 1) {
            this.target_yCoord_field.func_146201_a(par1, par2);
            this.lock_height_field.func_146201_a(par1, par2);
            if (this.tileEntity.getTier().ordinal() > 1) {
                this.target_freq_field.func_146201_a(par1, par2);
            }
        }
        try {
            Pos newTarget = new Pos(Integer.parseInt(this.target_xCoord_field.func_146179_b()), Math.max(Integer.parseInt(this.target_yCoord_field.func_146179_b()), 0), Integer.parseInt(this.target_zCoord_field.func_146179_b()));
            this.tileEntity.setTarget(newTarget);
            ICBMClassic.packetHandler.sendToServer(new PacketTile("target_C>S", 2, this.tileEntity).addData(new Object[]{this.tileEntity.getTarget().xi(), this.tileEntity.getTarget().yi(), this.tileEntity.getTarget().zi()}));
        }
        catch (NumberFormatException newTarget) {
            // empty catch block
        }
        try {
            short newFrequency = (short)Math.max(Short.parseShort(this.target_freq_field.func_146179_b()), 0);
            this.tileEntity.setFrequency(newFrequency);
            ICBMClassic.packetHandler.sendToServer(new PacketTile("frequency_C>S", 1, this.tileEntity).addData(new Object[]{this.tileEntity.getFrequency()}));
        }
        catch (NumberFormatException newFrequency) {
            // empty catch block
        }
        try {
            short newHeight;
            this.tileEntity.lockHeight = newHeight = (short)Math.max(Math.min(Short.parseShort(this.lock_height_field.func_146179_b()), Short.MAX_VALUE), 3);
            ICBMClassic.packetHandler.sendToServer(new PacketTile("lock_height_C>S", 3, this.tileEntity).addData(new Object[]{this.tileEntity.lockHeight}));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void func_73864_a(int par1, int par2, int par3) throws IOException {
        super.func_73864_a(par1, par2, par3);
        this.target_xCoord_field.func_146192_a(par1 - this.containerWidth, par2 - this.containerHeight, par3);
        this.target_zCoord_field.func_146192_a(par1 - this.containerWidth, par2 - this.containerHeight, par3);
        if (this.tileEntity.getTier().ordinal() >= 1) {
            this.target_yCoord_field.func_146192_a(par1 - this.containerWidth, par2 - this.containerHeight, par3);
            this.lock_height_field.func_146192_a(par1 - this.containerWidth, par2 - this.containerHeight, par3);
            if (this.tileEntity.getTier().ordinal() > 1) {
                this.target_freq_field.func_146192_a(par1 - this.containerWidth, par2 - this.containerHeight, par3);
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.launch_button.field_146127_k) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("launch_C>S", 4, this.tileEntity).addData(new Object[]{this.tileEntity.lockHeight}));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.target_xCoord_field.func_146194_f();
        this.target_zCoord_field.func_146194_f();
        if (this.tileEntity.getTier().ordinal() >= 1) {
            this.target_yCoord_field.func_146194_f();
            this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.launcherscreen.detHeight"), 12, 68, 0x404040);
            this.lock_height_field.func_146194_f();
            this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.launcherscreen.lockHeight"), 12, 83, 0x404040);
            if (this.tileEntity.getTier().ordinal() > 1) {
                this.target_freq_field.func_146194_f();
                this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.misc.freq"), 12, 98, 0x404040);
            }
        }
        this.field_146289_q.func_78276_b("", 45, 6, 0x404040);
        this.field_146289_q.func_78276_b("\u00a77" + LanguageUtility.getLocal("gui.launcherscreen.name"), 30, 6, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.launcherscreen.target"), 12, 25, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.misc.XCoord"), 25, 40, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.misc.ZCoord"), 25, 55, 0x404040);
        int inaccuracy = 30;
        if (this.tileEntity.launcherBase != null && this.tileEntity.launcherBase.supportFrame != null) {
            inaccuracy = this.tileEntity.launcherBase.supportFrame.getInaccuracy();
        }
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.launcherscreen.inaccuracy").replaceAll("%p", "" + inaccuracy), 12, 113, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.misc.status") + " " + this.tileEntity.getStatus(), 12, 125, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        int containerPosX = (this.field_146294_l - this.field_146999_f) / 2;
        int containerPosY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_146276_q_();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        this.containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(this.containerWidth, this.containerHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tileEntity.getEnergy() > 0) {
            float energyScale = (float)this.tileEntity.getEnergy() / (float)this.tileEntity.getEnergyBufferSize();
            int textureX = 176;
            int textureWidth = 8;
            int textureHeight = 71;
            int height = (int)Math.min(71.0, Math.floor(71.0f * energyScale));
            this.func_73729_b(containerPosX + 168, containerPosY + 65 + (71 - height), 176, 71 - height, 8, height);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.target_xCoord_field.func_146206_l()) {
            this.target_xCoord_field.func_146180_a(Math.round(this.tileEntity.getTarget().x()) + "");
        }
        if (!this.target_zCoord_field.func_146206_l()) {
            this.target_zCoord_field.func_146180_a(Math.round(this.tileEntity.getTarget().z()) + "");
        }
        if (!this.target_yCoord_field.func_146206_l()) {
            this.target_yCoord_field.func_146180_a(Math.round(this.tileEntity.getTarget().y()) + "");
        }
        if (!this.lock_height_field.func_146206_l()) {
            this.lock_height_field.func_146180_a(this.tileEntity.lockHeight + "");
        }
        if (!this.target_freq_field.func_146206_l()) {
            this.target_freq_field.func_146180_a(this.tileEntity.getFrequency() + "");
        }
    }
}

