/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity;

import com.builtbroken.jlib.data.vector.IPos3D;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLightBeam
extends Entity
implements IEntityAdditionalSpawnData {
    public float red = 1.0f;
    public float green = 0.0f;
    public float blue = 0.0f;
    public float beamSize = 0.5f;
    public float beamGlowSize = 1.0f;
    public float clientBeamProgress = 0.0f;
    public boolean deathCycle = false;
    public float targetBeamProgress = 1.0f;
    public float beamGrowthRate = 0.05f;
    private static final DataParameter<Float> BEAM_PROGRESS = EntityDataManager.func_187226_a(EntityLightBeam.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityLightBeam(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70156_m = true;
        this.field_70158_ak = true;
        this.field_70131_O = 1.0f;
        this.field_70130_N = 1.0f;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(BEAM_PROGRESS, (Object)Float.valueOf(-1.0f));
    }

    public EntityLightBeam setPosition(IPos3D position) {
        this.func_70107_b(position.x(), position.y(), position.z());
        return this;
    }

    public EntityLightBeam setColor(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        return this;
    }

    public void startDeathCycle() {
        this.deathCycle = true;
    }

    public void setTargetBeamProgress(float value) {
        this.targetBeamProgress = value;
    }

    public void setActualBeamProgress(float value) {
        this.func_184212_Q().func_187227_b(BEAM_PROGRESS, (Object)Float.valueOf(Math.min(1.0f, Math.max(0.0f, Float.valueOf(value).floatValue()))));
    }

    public float getBeamProgress() {
        return ((Float)this.func_184212_Q().func_187225_a(BEAM_PROGRESS)).floatValue();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(this.field_70165_t - 5.0, -10.0, this.field_70161_v - 5.0, this.field_70165_t + 5.0, Double.POSITIVE_INFINITY, this.field_70161_v + 5.0);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeFloat(this.red);
        data.writeFloat(this.green);
        data.writeFloat(this.blue);
        data.writeFloat(this.beamSize);
        data.writeFloat(this.beamGlowSize);
    }

    public void readSpawnData(ByteBuf data) {
        this.red = data.readFloat();
        this.green = data.readFloat();
        this.blue = data.readFloat();
        this.beamSize = data.readFloat();
        this.beamGlowSize = data.readFloat();
    }

    public void func_70071_h_() {
        if (this.getBeamProgress() < this.targetBeamProgress) {
            this.setActualBeamProgress(Math.min(this.targetBeamProgress, this.getBeamProgress() + this.beamGrowthRate));
        } else if (this.getBeamProgress() > this.targetBeamProgress) {
            this.setActualBeamProgress(Math.max(this.targetBeamProgress, this.getBeamProgress() - this.beamGrowthRate));
        }
        if (this.deathCycle && (double)Math.abs(this.getBeamProgress() - this.targetBeamProgress) <= 0.01) {
            this.func_70106_y();
        } else if (this.field_70173_aa > 6000) {
            this.func_70106_y();
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    protected void func_70037_a(NBTTagCompound var1) {
    }

    protected void func_70014_b(NBTTagCompound var1) {
    }
}

