/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.capability.launcher;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IMissileHolder;
import icbm.classic.api.caps.IMissileLauncher;
import icbm.classic.api.data.LaunchStatus;
import icbm.classic.lib.CapabilityPrefab;
import icbm.classic.lib.transform.vector.Pos;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilityMissileLauncher
extends CapabilityPrefab
implements IMissileLauncher {
    private double target_x;
    private double target_y;
    private double target_z;
    private BlockPos targetPos;
    public IMissileHolder holder;
    public Pos missileSpawnOffset;
    public TileEntity host;

    public CapabilityMissileLauncher(IMissileHolder holder, Pos missileSpawnOffset) {
        this.holder = holder;
        this.missileSpawnOffset = missileSpawnOffset;
    }

    @Override
    @Nonnull
    public IMissileHolder getMissileHolder() {
        return this.holder;
    }

    @Override
    public LaunchStatus launchMissile(@Nullable Entity cause) {
        return null;
    }

    @Override
    public LaunchStatus getLauncherStatus() {
        return null;
    }

    @Override
    public void setTarget(double x, double y, double z) {
        this.target_x = x;
        this.target_y = y;
        this.target_z = z;
        this.targetPos = new BlockPos(x, y, z);
    }

    @Override
    @Nullable
    public BlockPos getTarget() {
        return this.targetPos;
    }

    @Override
    public double getTargetX() {
        return this.target_x;
    }

    @Override
    public double getTargetY() {
        return this.target_y;
    }

    @Override
    public double getTargetZ() {
        return this.target_z;
    }

    @Override
    public boolean isCapability(@Nonnull Capability<?> capability) {
        return capability == ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY;
    }

    @Override
    protected void save(NBTTagCompound tag) {
        tag.func_74780_a("target_x", this.target_x);
        tag.func_74780_a("target_y", this.target_y);
        tag.func_74780_a("target_z", this.target_z);
    }

    @Override
    protected void load(NBTTagCompound nbt) {
        this.target_x = nbt.func_74769_h("target_x");
        this.target_y = nbt.func_74769_h("target_y");
        this.target_z = nbt.func_74769_h("target_z");
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IMissileLauncher.class, (Capability.IStorage)new Capability.IStorage<IMissileLauncher>(){

            @Nullable
            public NBTBase writeNBT(Capability<IMissileLauncher> capability, IMissileLauncher instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IMissileLauncher> capability, IMissileLauncher instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> new CapabilityMissileLauncher(null, null));
    }
}

