/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.handler;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.entity.projectiles.damagesources.AbstractOMTDamageSource;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.init.ModBlocks;
import omtteam.openmodularturrets.init.ModItems;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.util.OMTFakePlayer;
import omtteam.openmodularturrets.util.OMTUtil;

public class OMTEventHandler {
    private static OMTEventHandler instance;

    private OMTEventHandler() {
    }

    public static OMTEventHandler getInstance() {
        if (instance == null) {
            instance = new OMTEventHandler();
        }
        return instance;
    }

    @SubscribeEvent
    public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("openmodularturrets")) {
            ConfigManager.sync((String)"openmodularturrets", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public void entityHurtEvent(@Nonnull LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        int fakeDrops = OMTUtil.getFakeDropsLevel(entity);
        if (fakeDrops >= 0) {
            FakePlayer player = OMTFakePlayer.getFakePlayer((WorldServer)event.getEntityLiving().func_130014_f_());
            player.func_184611_a(EnumHand.MAIN_HAND, OMTFakePlayer.getSword(fakeDrops));
            entity.func_130011_c((Entity)player);
        }
    }

    @SubscribeEvent
    public void entityAttackedEvent(@Nonnull LivingAttackEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        int fakeDrops = OMTUtil.getFakeDropsLevel(entity);
        if (fakeDrops >= 0) {
            FakePlayer player = OMTFakePlayer.getFakePlayer((WorldServer)event.getEntityLiving().func_130014_f_());
            player.func_184611_a(EnumHand.MAIN_HAND, OMTFakePlayer.getSword(fakeDrops));
            entity.func_130011_c((Entity)player);
        }
    }

    @SubscribeEvent
    public void entityDeathEvent(@Nonnull LivingDeathEvent event) {
        if (event.getSource() instanceof AbstractOMTDamageSource) {
            ((AbstractOMTDamageSource)event.getSource()).getBase().increaseKillCounter();
            if (event.getEntity() instanceof EntityPlayer) {
                ((AbstractOMTDamageSource)event.getSource()).getBase().increasePlayerKillCounter();
            }
        }
    }

    @SubscribeEvent
    public void blockRegisterEvent(@Nonnull RegistryEvent.Register<Block> event) {
        ModBlocks.initBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public void itemRegisterEvent(@Nonnull RegistryEvent.Register<Item> event) {
        ModItems.init((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public void soundRegistryEvent(@Nonnull RegistryEvent.Register<SoundEvent> event) {
        ModSounds.init((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public void renderRegisterEvent(ModelRegistryEvent event) {
        OpenModularTurrets.proxy.initModelLoaders();
    }

    @SubscribeEvent
    public void lootEvent(@Nonnull LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        int fakeDrops = OMTUtil.getFakeDropsLevel(entity);
        if (entity.func_184216_O().contains("openmodularturrets:turret_hit") && !OMTConfig.GENERAL.doTurretsKillsDropMobLoot && (fakeDrops < 0 || !OMTConfig.GENERAL.doLootAddonsOverrideMobLootSetting) || entity.func_184216_O().contains("openmodularturrets:dont_drop_loot")) {
            event.setCanceled(true);
        }
    }
}

