/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.farming;

import forestry.api.farming.FarmDirection;
import net.minecraft.util.math.BlockPos;

public interface IExtentCache {
    public int getExtents(FarmDirection var1, BlockPos var2);

    public void setExtents(FarmDirection var1, BlockPos var2, int var3);

    public void cleanExtents(FarmDirection var1);

    default public int getValidExtent(FarmDirection direction, BlockPos pos, int maxExtend) {
        int lastExtents = this.getExtents(direction, pos);
        if (lastExtents > maxExtend) {
            lastExtents = 0;
        }
        return lastExtents;
    }

    default public BlockPos getValidPosition(FarmDirection direction, BlockPos pos, int maxExtend, BlockPos baseLocation) {
        int extent = this.getValidExtent(direction, pos, maxExtend);
        return baseLocation.func_177967_a(direction.getFacing(), extent);
    }

    default public int increaseExtent(FarmDirection direction, BlockPos pos, int maxExtend) {
        int validExtent = this.getValidExtent(direction, pos, maxExtend);
        this.setExtents(direction, pos, ++validExtent);
        return validExtent;
    }
}

