/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.gui.elements;

import forestry.api.climate.IClimateTransformer;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.gui.events.GuiEvent;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.gui.elements.GuiElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SpeciesSelectionElement
extends GuiElement {
    public SpeciesSelectionElement(int xPos, int yPos, IClimateTransformer transformer) {
        super(xPos, yPos, 22, 22);
        this.addSelfEventHandler(GuiEvent.DownEvent.class, event -> {
            float humid;
            float temp;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack itemstack = player.field_71071_by.func_70445_o();
            if (itemstack.func_190926_b()) {
                return;
            }
            IIndividual individual = AlleleManager.alleleRegistry.getIndividual(itemstack);
            if (individual == null) {
                return;
            }
            IAlleleSpecies primary = individual.getGenome().getPrimary();
            EnumTemperature temperature = primary.getTemperature();
            EnumHumidity humidity = primary.getHumidity();
            switch (temperature) {
                case HELLISH: {
                    temp = 2.0f;
                    break;
                }
                case HOT: {
                    temp = 1.25f;
                    break;
                }
                case WARM: {
                    temp = 0.9f;
                    break;
                }
                case COLD: {
                    temp = 0.15f;
                    break;
                }
                case ICY: {
                    temp = 0.0f;
                    break;
                }
                default: {
                    temp = 0.79f;
                }
            }
            switch (humidity) {
                case DAMP: {
                    humid = 0.9f;
                    break;
                }
                case ARID: {
                    humid = 0.2f;
                    break;
                }
                default: {
                    humid = 0.4f;
                }
            }
            transformer.setTarget(ClimateStateHelper.INSTANCE.create(temp, humid));
        });
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        super.drawElement(mouseX, mouseY);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(new ResourceLocation("forestry", "textures/gui/habitat_former.png"));
        GlStateManager.func_179141_d();
        this.func_73729_b(0, 0, 224, 46, 22, 22);
        GlStateManager.func_179118_c();
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }
}

