/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.api.farming.ISoil;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicSoil;
import forestry.farming.logic.farmables.FarmableCocoa;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FarmLogicCocoa
extends FarmLogicSoil {
    private static final int[] LAYOUT_POSITIONS = new int[]{4, 1, 3, 0, 2};
    private final IFarmable cocoa = new FarmableCocoa();

    public FarmLogicCocoa(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    public ItemStack getIconItemStack() {
        return new ItemStack(Items.field_151100_aR, 1, 3);
    }

    @Override
    public String getUnlocalizedName() {
        return "for.farm.cocoa";
    }

    @Override
    public int getFertilizerConsumption() {
        return 120;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(20.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return this.cocoa.isGermling(itemstack);
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        if (this.maintainSoil(world, farmHousing, pos, direction, extent)) {
            return true;
        }
        BlockPos position = farmHousing.getValidPosition(direction, pos, extent, pos.func_177984_a());
        boolean result = this.tryPlantingCocoa(world, farmHousing, position, direction);
        farmHousing.increaseExtent(direction, pos, extent);
        return result;
    }

    protected boolean maintainSoil(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        if (!farmHousing.canPlantSoil(this.isManual)) {
            return false;
        }
        BlockPos cornerPos = farmHousing.getFarmCorner(direction);
        int distance = this.getDistanceValue(direction.getFacing().func_176732_a(EnumFacing.Axis.Y), cornerPos, pos) - 1;
        int layoutExtent = LAYOUT_POSITIONS[distance % LAYOUT_POSITIONS.length];
        block0: for (ISoil soil : this.getSoils()) {
            BlockPos position;
            NonNullList resources = NonNullList.func_191196_a();
            resources.add((Object)soil.getResource());
            for (int i = 0; i < extent && world.func_175667_e(position = this.translateWithOffset(pos, direction, i)); ++i) {
                if (!this.isValidPosition(direction, position, pos, layoutExtent) || !farmHousing.getFarmInventory().hasResources((NonNullList<ItemStack>)resources)) continue;
                BlockPos platformPosition = position.func_177977_b();
                if (!farmHousing.isValidPlatform(world, platformPosition)) continue block0;
                for (int z = 0; z < 3; ++z) {
                    BlockPos location = position.func_177981_b(z);
                    IBlockState state = world.func_180495_p(location);
                    if (z == 0 && !world.func_175623_d(location) || z > 0 && this.isAcceptedSoil(state) || !BlockUtil.isBreakableBlock(state, world, pos)) continue;
                    if (!BlockUtil.isReplaceableBlock(state, world, location)) {
                        BlockUtil.getBlockDrops(world, location).forEach(farmHousing::addPendingProduce);
                        world.func_175698_g(location);
                        return this.trySetSoil(world, farmHousing, location, soil.getResource(), soil.getSoilState());
                    }
                    if (this.isManual) continue;
                    return this.trySetSoil(world, farmHousing, location, soil.getResource(), soil.getSoilState());
                }
            }
        }
        return false;
    }

    protected int getDistanceValue(EnumFacing facing, BlockPos posA, BlockPos posB) {
        int value;
        BlockPos delta = posA.func_177973_b((Vec3i)posB);
        switch (facing.func_176740_k()) {
            case X: {
                value = delta.func_177958_n();
                break;
            }
            case Y: {
                value = delta.func_177956_o();
                break;
            }
            case Z: {
                value = delta.func_177952_p();
                break;
            }
            default: {
                value = 0;
            }
        }
        return Math.abs(value);
    }

    protected boolean isValidPosition(FarmDirection direction, BlockPos pos, BlockPos logicPos, int layoutExtent) {
        int distance = this.getDistanceValue(direction.getFacing(), pos, logicPos);
        return distance % LAYOUT_POSITIONS.length == layoutExtent;
    }

    protected boolean trySetSoil(World world, IFarmHousing farmHousing, BlockPos position, ItemStack resource, IBlockState ground) {
        NonNullList resources = NonNullList.func_191196_a();
        resources.add((Object)resource);
        if (!farmHousing.getFarmInventory().hasResources((NonNullList<ItemStack>)resources)) {
            return false;
        }
        if (!BlockUtil.setBlockWithPlaceSound(world, position, ground)) {
            return false;
        }
        farmHousing.getFarmInventory().removeResources((NonNullList<ItemStack>)resources);
        return true;
    }

    @Override
    public Collection<ICrop> harvest(World world, IFarmHousing housing, BlockPos pos, FarmDirection direction, int extent) {
        BlockPos position = housing.getValidPosition(direction, pos, extent, pos.func_177984_a());
        Collection<ICrop> crops = this.getHarvestBlocks(world, position);
        housing.increaseExtent(direction, pos, extent);
        return crops;
    }

    private boolean tryPlantingCocoa(World world, IFarmHousing farmHousing, BlockPos position, FarmDirection farmDirection) {
        BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos(position);
        IBlockState blockState = world.func_180495_p((BlockPos)current);
        while (FarmLogicCocoa.isJungleTreeTrunk(blockState)) {
            for (EnumFacing direction : EnumFacing.field_176754_o) {
                BlockPos candidate = new BlockPos(current.func_177958_n() + direction.func_82601_c(), current.func_177956_o(), current.func_177952_p() + direction.func_82599_e());
                if (!world.func_175667_e(candidate) || !world.func_175623_d(candidate)) continue;
                return farmHousing.plantGermling(this.cocoa, world, candidate, farmDirection);
            }
            current.func_189536_c(EnumFacing.UP);
            if (current.func_177956_o() - position.func_177956_o() > 1) break;
            blockState = world.func_180495_p((BlockPos)current);
        }
        return false;
    }

    private static boolean isJungleTreeTrunk(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        return block == Blocks.field_150364_r && blockState.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE;
    }

    private Collection<ICrop> getHarvestBlocks(World world, BlockPos position) {
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        Stack<ICrop> crops = new Stack<ICrop>();
        IBlockState blockState = world.func_180495_p(position);
        Block block = blockState.func_177230_c();
        ICrop crop = null;
        if (!block.isWood((IBlockAccess)world, position) && (crop = this.cocoa.getCropAt(world, position, blockState)) == null) {
            return crops;
        }
        if (crop != null) {
            crops.add(crop);
        }
        List<BlockPos> candidates = this.processHarvestBlock(world, crops, seen, position, position);
        ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
        while (!candidates.isEmpty() && crops.size() < 20) {
            for (BlockPos candidate : candidates) {
                temp.addAll(this.processHarvestBlock(world, crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private List<BlockPos> processHarvestBlock(World world, Stack<ICrop> crops, Set<BlockPos> seen, BlockPos start, BlockPos position) {
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockPos candidate = position.func_177982_a(i, j, k);
                    if (candidate.equals((Object)position) || Math.abs(candidate.func_177958_n() - start.func_177958_n()) > 5 || Math.abs(candidate.func_177952_p() - start.func_177952_p()) > 5 || seen.contains(candidate) || !world.func_175667_e(candidate)) continue;
                    IBlockState blockState = world.func_180495_p(candidate);
                    ICrop crop = this.cocoa.getCropAt(world, candidate, blockState);
                    if (crop != null) {
                        crops.push(crop);
                        candidates.add(candidate);
                        seen.add(candidate);
                        continue;
                    }
                    if (!blockState.func_177230_c().isWood((IBlockAccess)world, candidate)) continue;
                    candidates.add(candidate);
                    seen.add(candidate);
                }
            }
        }
        return candidates;
    }
}

