/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.farming.logic.FarmLogic;
import forestry.farming.logic.crops.CropRubber;
import forestry.plugins.PluginIC2;
import forestry.plugins.PluginTechReborn;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicRubber
extends FarmLogic {
    private boolean active = true;

    public FarmLogicRubber(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
        if ((PluginIC2.rubberWood == null || PluginIC2.resin == null) && PluginTechReborn.rubberItemsSuccess()) {
            Log.warning("Failed to init a farm logic {} since IC2 rubber wood or resin were not found", this.getClass().getName());
            this.active = false;
        }
    }

    @Override
    public ItemStack getIconItemStack() {
        if (ModUtil.isModLoaded("ic2")) {
            return PluginIC2.resin;
        }
        if (ModUtil.isModLoaded("techreborn")) {
            return PluginTechReborn.sap;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public String getUnlocalizedName() {
        return "for.farm.rubber";
    }

    @Override
    public int getFertilizerConsumption() {
        return 40;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(5.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        if (!this.active) {
            return Collections.emptyList();
        }
        BlockPos position = farmHousing.getValidPosition(direction, pos, extent, pos.func_177984_a());
        Collection<ICrop> crops = this.getHarvestBlocks(world, position);
        farmHousing.increaseExtent(direction, pos, extent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(World world, BlockPos position) {
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int j = 0; j < 10; ++j) {
            BlockPos candidate = position.func_177982_a(0, j, 0);
            if (!world.func_175667_e(candidate)) {
                return crops;
            }
            IBlockState blockState = world.func_180495_p(candidate);
            Block block = blockState.func_177230_c();
            if (PluginIC2.rubberWood != null && !ItemStackUtil.equals(block, PluginIC2.rubberWood) && PluginTechReborn.RUBBER_WOOD != null && !ItemStackUtil.equals(block, PluginTechReborn.RUBBER_WOOD)) break;
            if (!CropRubber.hasRubberToHarvest(blockState)) continue;
            crops.push(new CropRubber(world, blockState, candidate));
            break;
        }
        return crops;
    }
}

