/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thaumcraft.handlers.handlers;

import com.blamejared.ModTweaker;
import com.blamejared.compat.thaumcraft.handlers.ThaumCraft;
import com.blamejared.compat.thaumcraft.handlers.aspects.CTAspectStack;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.internal.CommonInternals;

@ZenClass(value="mods.thaumcraft.Infusion")
@ZenRegister
@ModOnly(value="thaumcraft")
public class Infusion {
    @ZenMethod
    public static void registerRecipe(String name, String research, IItemStack output, int instability, CTAspectStack[] aspects, IIngredient centralItem, IIngredient[] recipe) {
        InfusionRecipe infRecipe = new InfusionRecipe(research, (Object)InputHelper.toStack((IItemStack)output), instability, ThaumCraft.getAspects(aspects), InputHelper.toObject((IIngredient)centralItem), InputHelper.toObjects((IIngredient[])recipe));
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(new ResourceLocation("thaumcraft", name), infRecipe));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(output));
    }

    @ZenMethod
    public static void removeRecipe(String recipeName) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(recipeName));
    }

    private static class Remove
    extends BaseAction {
        private IItemStack output;
        private String recipeName;

        public Remove(IItemStack output) {
            super("Infusion");
            this.output = output;
        }

        public Remove(String recipeName) {
            super("Infusion");
            this.recipeName = recipeName;
        }

        public void apply() {
            ArrayList remove = new ArrayList();
            for (Map.Entry entry : CommonInternals.craftingRecipeCatalog.entrySet()) {
                if (!(entry.getValue() instanceof InfusionRecipe)) continue;
                InfusionRecipe recipe = (InfusionRecipe)entry.getValue();
                if (this.output != null) {
                    IItemStack recOutput;
                    if (!(recipe.getRecipeOutput() instanceof ItemStack) || !this.output.matches(recOutput = InputHelper.toIItemStack((ItemStack)((ItemStack)recipe.getRecipeOutput())))) continue;
                    remove.add(entry.getKey());
                    continue;
                }
                if (this.recipeName == null || !((ResourceLocation)entry.getKey()).toString().equals(this.recipeName)) continue;
                remove.add(entry.getKey());
            }
            remove.forEach(CommonInternals.craftingRecipeCatalog::remove);
        }

        public String describe() {
            return "Removing Infusion recipe for:" + this.getRecipeInfo();
        }

        protected String getRecipeInfo() {
            if (this.output == null) {
                return this.recipeName;
            }
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class Add
    extends BaseAction {
        private ResourceLocation resourceLocation;
        private InfusionRecipe recipe;

        public Add(ResourceLocation resourceLocation, InfusionRecipe recipe) {
            super("Infusion");
            this.resourceLocation = resourceLocation;
            this.recipe = recipe;
        }

        public void apply() {
            ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)this.resourceLocation, (InfusionRecipe)this.recipe);
        }

        public String describe() {
            return "Adding infusion recipe for: " + this.recipe.recipeOutput;
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.recipe.getRecipeOutput());
        }
    }
}

