/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.ACentauriSystem;

import asmodeuscore.api.IBodies;
import asmodeuscore.api.IBodiesHandler;
import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesRegistry;
import galaxyspace.core.proxy.ClientProxy;
import galaxyspace.core.util.GSDimensions;
import galaxyspace.systems.ACentauriSystem.core.ACBlocks;
import galaxyspace.systems.ACentauriSystem.core.configs.ACConfigCore;
import galaxyspace.systems.ACentauriSystem.core.configs.ACConfigDimensions;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.blocks.Proxima_B_Blocks;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.dimension.TeleportTypeProxima_B;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.dimension.WorldProviderProxima_B_WE;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.recipes.CraftingRecipesProximaB;
import java.io.File;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@IBodiesHandler
public class ACentauriSystemBodies
implements IBodies {
    public static SolarSystem aCentauriSystem;
    public static SolarSystem ProximaSystem;
    public static Star aCentauri;
    public static Planet centauri_b;
    public static Star proxima;
    public static Planet proxima_b;
    public static Planet proxima_c;

    public void preInitialization(FMLPreInitializationEvent event) {
        new ACConfigCore(new File(event.getModConfigurationDirectory(), "GalaxySpace/alpha_centauri/core.conf"));
        new ACConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/alpha_centauri/dimensions.conf"));
    }

    public boolean canRegister() {
        return ACConfigCore.enableACentauriSystems;
    }

    public void preInit(FMLPreInitializationEvent event) {
        aCentauriSystem = BodiesRegistry.registerSolarSystem((String)"galaxyspace", (String)"acentauri", (BodiesRegistry.Galaxies)BodiesRegistry.Galaxies.MILKYWAY, (Vector3)new Vector3(1.5, 0.0, 0.0), (String)"centauri_a", (float)1.3f);
        GalaxyRegistry.registerSolarSystem((SolarSystem)aCentauriSystem);
        centauri_b = BodiesRegistry.registerExPlanet((SolarSystem)aCentauriSystem, (String)"centauri_b", (String)"galaxyspace", (float)0.3f);
        centauri_b.setRingColorRGB(0.0f, 0.0f, 0.0f);
        BodiesRegistry.setOrbitData((CelestialBody)centauri_b, (float)((float)Math.PI), (float)1.5f, (float)1000.0f);
        GalaxyRegistry.registerPlanet((Planet)centauri_b);
        ProximaSystem = BodiesRegistry.registerSolarSystem((String)"galaxyspace", (String)"proxima", (BodiesRegistry.Galaxies)BodiesRegistry.Galaxies.MILKYWAY, (Vector3)new Vector3((double)1.7f, (double)-0.2f, 0.0), (String)"proxima", (float)0.8f);
        GalaxyRegistry.registerSolarSystem((SolarSystem)ProximaSystem);
        proxima_b = BodiesRegistry.registerExPlanet((SolarSystem)ProximaSystem, (String)"proxima_b", (String)"galaxyspace", (float)0.25f);
        BodiesRegistry.setAtmosphere((CelestialBody)proxima_b, (boolean)false, (boolean)true, (boolean)false, (float)0.5f, (float)0.4f, (float)0.0f);
        BodiesRegistry.setOrbitData((CelestialBody)proxima_b, (float)((float)Math.PI * 3), (float)1.2f, (float)2.0f);
        BodiesRegistry.setPlanetData((CelestialBody)proxima_b, (int)2, (long)35050L, (float)BodiesRegistry.calculateGravity((float)8.0f), (boolean)true);
        BodiesRegistry.setProviderData((CelestialBody)proxima_b, WorldProviderProxima_B_WE.class, (int)ACConfigDimensions.dimensionIDProxima_B, (int)6, (Biome[])new Biome[0]);
        proxima_b.setRingColorRGB(0.0f, 0.4f, 0.9f).atmosphereComponent(EnumAtmosphericGas.CO2);
        GalaxyRegistry.registerPlanet((Planet)proxima_b);
        ACBlocks.initialize();
        ACentauriSystemBodies.registrycelestial();
        ACentauriSystemBodies.registryteleport();
    }

    public void init(FMLInitializationEvent event) {
    }

    public void postInit(FMLPostInitializationEvent event) {
        GSDimensions.PROXIMA_B = WorldUtil.getDimensionTypeById((int)ACConfigDimensions.dimensionIDProxima_B);
    }

    private static void registrycelestial() {
        BodiesData data = new BodiesData(IAdvancedSpace.TypeBody.STAR).setStarClass(IAdvancedSpace.StarClass.DWARF).setStarColor(IAdvancedSpace.StarColor.YELLOW);
        BodiesRegistry.registerBodyData((CelestialBody)centauri_b, (BodiesData)data);
        data = new BodiesData(IAdvancedSpace.TypeBody.STAR).setStarClass(IAdvancedSpace.StarClass.DWARF).setStarColor(IAdvancedSpace.StarColor.YELLOW);
        BodiesRegistry.registerBodyData((CelestialBody)aCentauriSystem.getMainStar(), (BodiesData)data);
        data = new BodiesData(IAdvancedSpace.TypeBody.STAR).setStarClass(IAdvancedSpace.StarClass.DWARF).setStarColor(IAdvancedSpace.StarColor.ORANGE);
        BodiesRegistry.registerBodyData((CelestialBody)ProximaSystem.getMainStar(), (BodiesData)data);
    }

    private static void registryteleport() {
        GalacticraftRegistry.registerTeleportType(WorldProviderProxima_B_WE.class, (ITeleportType)new TeleportTypeProxima_B());
    }

    public void registerRender() {
        for (Proxima_B_Blocks.EnumBlockProximaB blockBasic : Proxima_B_Blocks.EnumBlockProximaB.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)ACBlocks.PROXIMA_B_BLOCKS, (int)blockBasic.getMeta(), (String)("proxima/" + blockBasic.func_176610_l()));
        }
        ClientUtil.registerBlockJson((String)"galaxyspace:proxima/", (Block)ACBlocks.PROXINA_B_LOG_1);
        ClientUtil.registerBlockJson((String)"galaxyspace:proxima/", (Block)ACBlocks.PROXINA_B_LOG_2);
    }

    public void registerVariant() {
        String[] blocks = new String[Proxima_B_Blocks.EnumBlockProximaB.values().length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = Proxima_B_Blocks.EnumBlockProximaB.byMetadata(i).func_176610_l();
        }
        ClientProxy.addVariant("proxima_b_blocks", "proxima/", blocks);
        ClientProxy.addVariant("proxima_b_log_1", "proxima/", "proxima_b_log_1");
        ClientProxy.addVariant("proxima_b_log_2", "proxima/", "proxima_b_log_2");
    }

    public void registerRecipes() {
        CraftingRecipesProximaB.loadRecipes();
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        ACBlocks.oreDictRegistration();
    }
}

