/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.data;

import com.google.common.cache.Cache;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Deque;
import net.minecraft.util.math.MathHelper;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.data.ITask;
import pregenerator.impl.client.preview.world.WorldSeed;
import pregenerator.impl.client.preview.world.data.IChunkData;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.Tuple;

public class Tasks {

    public static class StoreHeightData
    implements ITask {
        int x;
        int y;
        int[] data;

        public StoreHeightData(int x, int y, int[] data) {
            this.x = x;
            this.y = y;
            this.data = data;
        }

        @Override
        public void handleTask(RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
            ByteBuffer buffer = ByteBuffer.allocate((int)IFileProvider.FileType.HeightData.getOffset());
            buffer.put((byte)1);
            for (int i = 0; i < this.data.length; ++i) {
                buffer.put((byte)(this.data[i] - 128));
            }
            heightData.seek(provider.getOrCreateIndex(this.x, this.y, IFileProvider.FileType.HeightData));
            heightData.write(buffer.array());
        }
    }

    public static class FetchHeightData
    implements ITask {
        int x;
        int y;
        int[] data = new int[0];
        boolean done = false;

        public FetchHeightData(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void handleTask(RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
            ByteBuffer buffer = this.readBytes(heightData, provider.getIndex(this.x, this.y, IFileProvider.FileType.HeightData), IFileProvider.FileType.HeightData.getOffset());
            if (buffer.get() <= 0) {
                this.done = true;
                return;
            }
            int[] fetch = new int[256];
            for (int i = 0; i < fetch.length; ++i) {
                fetch[i] = buffer.get() + 128;
            }
            this.data = fetch;
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }

        public int[] getHeightData() {
            return this.data;
        }
    }

    public static class MassFetchTask
    implements ITask {
        Deque<Tuple<IChunkData, Integer>> result;
        int view;
        IFileProvider.FileType chunkType;

        public MassFetchTask(Deque<Tuple<IChunkData, Integer>> result, int view) {
            this.result = result;
            this.view = view;
            this.chunkType = WorldSeed.isUsingCompression() ? IFileProvider.FileType.Compressed_Chunk_Data : IFileProvider.FileType.Chunk_Data;
        }

        @Override
        public void handleTask(RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
            int total = provider.getStored();
            for (int i = 0; i < total; i += 1024) {
                this.gatherChunks(i, MathHelper.func_76125_a((int)(total - i), (int)0, (int)1024), chunkData, heightData);
            }
        }

        public void gatherChunks(long startValue, long size, RandomAccessFile chunkData, RandomAccessFile heightData) throws Exception {
            if (size <= 0L) {
                return;
            }
            ByteBuffer chunkBuffer = this.readBytes(chunkData, startValue * IFileProvider.FileType.Chunk_Data.getOffset(), size * IFileProvider.FileType.Chunk_Data.getOffset());
            ByteBuffer heigthBuffer = this.readBytes(heightData, startValue * IFileProvider.FileType.HeightData.getOffset(), size * IFileProvider.FileType.HeightData.getOffset());
            int k = 0;
            while ((long)k < size) {
                chunkBuffer.position((int)((long)k * IFileProvider.FileType.Chunk_Data.getOffset()));
                heigthBuffer.position((int)((long)k * IFileProvider.FileType.HeightData.getOffset()));
                if (chunkBuffer.get() > 0) {
                    this.result.add(new Tuple<IChunkData, Integer>(this.chunkType.createData(chunkBuffer, heigthBuffer), this.view));
                }
                ++k;
            }
        }
    }

    public static class FetchChunkTask
    implements ITask {
        int chunkX;
        int chunkY;
        IChunkData data;
        boolean done = false;
        IFileProvider.FileType type;
        Cache<FilePos, IChunkData> cache;

        public FetchChunkTask(int x, int z, Cache<FilePos, IChunkData> data) {
            this.cache = data;
            this.chunkX = x;
            this.chunkY = z;
            this.type = WorldSeed.isUsingCompression() ? IFileProvider.FileType.Compressed_Chunk_Data : IFileProvider.FileType.Chunk_Data;
        }

        @Override
        public void handleTask(RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
            if (!provider.hasIndex(this.chunkX, this.chunkY)) {
                this.data = null;
                this.done = true;
                return;
            }
            ByteBuffer chunkBuffer = this.readBytes(chunkData, provider.getIndex(this.chunkX, this.chunkY, this.type), this.type.getOffset());
            if (chunkBuffer.get() <= 0) {
                this.data = null;
                this.done = true;
                return;
            }
            this.data = this.type.createData(chunkBuffer, this.readBytes(heightData, provider.getIndex(this.chunkX, this.chunkY, IFileProvider.FileType.HeightData), IFileProvider.FileType.HeightData.getOffset()));
            this.done = true;
            if (this.data != null) {
                this.cache.put((Object)new FilePos(this.chunkX, this.chunkY), (Object)this.data);
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public IChunkData getData() {
            return this.data;
        }
    }
}

