/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.config;

import appeng.api.definitions.IItemDefinition;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public enum Upgrades {
    CAPACITY(0),
    REDSTONE(0),
    CRAFTING(0),
    FUZZY(1),
    SPEED(1),
    INVERTER(1);

    private final int tier;
    private final Map<ItemStack, Integer> supportedMax = new HashMap<ItemStack, Integer>();

    private Upgrades(int tier) {
        this.tier = tier;
    }

    public Map<ItemStack, Integer> getSupported() {
        return this.supportedMax;
    }

    public void registerItem(IItemDefinition item, int maxSupported) {
        item.maybeStack(1).ifPresent(is -> this.registerItem((ItemStack)is, maxSupported));
    }

    public void registerItem(ItemStack stack, int maxSupported) {
        if (stack != null) {
            this.supportedMax.put(stack, maxSupported);
        }
    }

    public int getTier() {
        return this.tier;
    }
}

