/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.infopiece;

import com.buuz135.industrial.tile.generator.AbstractFuelGenerator;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;

public class PetrifiedFuelInfoPiece
extends BasicRenderedGuiPiece {
    private AbstractFuelGenerator tile;

    public PetrifiedFuelInfoPiece(AbstractFuelGenerator tile, int left, int top) {
        super(left, top, 76, 55, new ResourceLocation("industrialforegoing", "textures/gui/machines.png"), 1, 1);
        this.tile = tile;
    }

    public void drawForegroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, int mouseX, int mouseY) {
        super.drawForegroundLayer(container, guiX, guiY, mouseX, mouseY);
        if (this.tile != null) {
            long timeLeft = 0L;
            long generatingRate = 0L;
            if (this.tile.getGeneratedPowerStored() > 0L) {
                timeLeft = this.tile.getGeneratedPowerStored() / 2L / this.tile.getGeneratedPowerReleaseRate() / 20L;
                generatingRate = this.tile.getGeneratedPowerReleaseRate();
            }
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.getLeft() + 2), (float)(this.getTop() + 2), (float)0.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            renderer.func_78276_b(TextFormatting.DARK_GRAY + new TextComponentTranslation("text.industrialforegoing.display.burning", new Object[0]).func_150254_d(), 4, 4, 0xFFFFFF);
            renderer.func_78276_b(TextFormatting.DARK_GRAY + this.getFormatedTime(timeLeft * 1000L), 8, renderer.field_78288_b + 5, 0xFFFFFF);
            renderer.func_78276_b(TextFormatting.DARK_GRAY + new TextComponentTranslation("text.industrialforegoing.display.producing", new Object[0]).func_150254_d(), 4, 2 * renderer.field_78288_b + 9, 0xFFFFFF);
            renderer.func_78276_b(TextFormatting.DARK_GRAY + "" + generatingRate + " RF/tick", 8, 3 * renderer.field_78288_b + 10, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
    }

    private String getFormatedTime(long time) {
        return String.format("%02dm %02ds", TimeUnit.MILLISECONDS.toMinutes(time) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(time)), TimeUnit.MILLISECONDS.toSeconds(time) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(time)));
    }
}

