/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.core.recipe;

import WayofTime.bloodmagic.core.registry.OrbRegistry;
import WayofTime.bloodmagic.orb.BloodOrb;
import WayofTime.bloodmagic.orb.IBloodOrb;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IngredientBloodOrb
extends Ingredient {
    private final BloodOrb orb;
    private NonNullList<ItemStack> orbs;
    private IntList itemIds = null;
    private ItemStack[] items;

    public IngredientBloodOrb(BloodOrb orb) {
        super(new ItemStack[0]);
        this.orb = orb;
        List<ItemStack> orbGet = OrbRegistry.getOrbsDownToTier(orb.getTier());
        this.orbs = NonNullList.func_191197_a((int)orbGet.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < orbGet.size(); ++i) {
            this.orbs.set(i, (Object)orbGet.get(i));
        }
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.items == null) {
            this.items = (ItemStack[])this.orbs.toArray((Object[])new ItemStack[0]);
        }
        return this.items;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public IntList func_194139_b() {
        if (this.itemIds == null || this.itemIds.size() != this.orbs.size()) {
            this.itemIds = new IntArrayList(this.orbs.size());
            for (ItemStack itemstack : this.orbs) {
                this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)itemstack));
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.itemIds;
    }

    public boolean apply(@Nullable ItemStack input) {
        if (input == null || input.func_190926_b()) {
            return false;
        }
        if (!input.func_77942_o()) {
            return false;
        }
        if (!(input.func_77973_b() instanceof IBloodOrb)) {
            return false;
        }
        BloodOrb orb = ((IBloodOrb)input.func_77973_b()).getOrb(input);
        return orb != null && orb.getTier() >= this.orb.getTier();
    }

    protected void invalidate() {
        this.itemIds = null;
    }
}

