/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.client.gui.button;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import wanion.lib.WanionLib;
import wanion.lib.client.gui.WGuiContainer;
import wanion.lib.client.gui.button.WButton;
import wanion.lib.client.gui.interaction.WInteraction;
import wanion.lib.client.gui.interaction.WMouseInteraction;
import wanion.lib.common.control.IControlNameable;
import wanion.lib.common.control.IState;
import wanion.lib.common.control.IStateNameable;
import wanion.lib.common.control.IStateProvider;
import wanion.lib.network.SmartNBTMessage;

@SideOnly(value=Side.CLIENT)
public class ControlWButton<C extends IStateProvider<C, S>, S extends IState<S>>
extends WButton {
    protected final C stateProvider;
    protected int lineWidth = 0;

    public ControlWButton(@Nonnull C stateProvider, @Nonnull WGuiContainer<?> wGuiContainer, int x, int y) {
        this(stateProvider, wGuiContainer, x, y, 18, 18);
    }

    public ControlWButton(@Nonnull C stateProvider, @Nonnull WGuiContainer<?> wGuiContainer, int x, int y, int width, int height) {
        super(wGuiContainer, x, y, width, height);
        this.stateProvider = stateProvider;
    }

    @Override
    public void draw(@Nonnull WInteraction wInteraction) {
        Object state = this.stateProvider.getState();
        ResourceLocation textureResourceLocation = state.getTextureResourceLocation();
        Pair<Integer, Integer> texturePos = state.getTexturePos(wInteraction.isHovering(this));
        if (textureResourceLocation == null || texturePos == null) {
            return;
        }
        this.getTextureManager().func_110577_a(textureResourceLocation);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)this.getUsableX(), (int)this.getUsableY(), (float)((Integer)texturePos.getLeft()).intValue(), (float)((Integer)texturePos.getRight()).intValue(), (int)this.width, (int)this.height, (float)128.0f, (float)128.0f);
    }

    @Override
    public void drawForeground(@Nonnull WInteraction interaction) {
        String desc;
        if (!interaction.isHovering(this)) {
            return;
        }
        ArrayList<String> description = new ArrayList<String>();
        Object state = this.stateProvider.getState();
        if (this.stateProvider instanceof IControlNameable) {
            description.add(state instanceof IStateNameable ? TextFormatting.RED + I18n.func_135052_a((String)((IControlNameable)this.stateProvider).getControlName(), (Object[])new Object[0]) + ": " + TextFormatting.WHITE + I18n.func_135052_a((String)((IStateNameable)state).getStateName(), (Object[])new Object[0]) : TextFormatting.RED + I18n.func_135052_a((String)((IControlNameable)this.stateProvider).getControlName(), (Object[])new Object[0]));
        }
        if (state instanceof IStateNameable && (desc = ((IStateNameable)state).getStateDescription()) != null) {
            description.add(I18n.func_135052_a((String)desc, (Object[])new Object[0]));
        }
        this.lineWidth = 0;
        for (String line : description) {
            int lineWidth = this.getFontRenderer().func_78256_a(line);
            if (lineWidth <= this.lineWidth) continue;
            this.lineWidth = lineWidth;
        }
        this.wGuiContainer.func_146283_a(description, this.getTooltipX(interaction), this.getTooltipY(interaction));
    }

    @Override
    public void interaction(@Nonnull WMouseInteraction mouseInteraction) {
        Object state = this.stateProvider.getState();
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        NBTTagList controlTagList = new NBTTagList();
        NBTTagCompound controlNBT = new NBTTagCompound();
        this.stateProvider.writeToNBT(controlNBT, mouseInteraction.getMouseButton() == 0 ? state.getNextState() : state.getPreviousState());
        controlTagList.func_74742_a((NBTBase)controlNBT);
        nbtTagCompound.func_74782_a("control", (NBTBase)controlTagList);
        WanionLib.networkWrapper.sendToServer((IMessage)new SmartNBTMessage(this.getWindowID(), nbtTagCompound));
        this.playPressSound();
    }
}

