/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import tonius.simplyjetpacks.capability.IEnergyContainerItem;
import tonius.simplyjetpacks.item.ItemFluxpack;
import tonius.simplyjetpacks.item.ItemJetpack;
import tonius.simplyjetpacks.proxy.CommonProxy;
import tonius.simplyjetpacks.setup.ParticleType;
import tonius.simplyjetpacks.util.ItemHelper;
import tonius.simplyjetpacks.util.NBTHelper;

public class UpgradingRecipeShapeless
extends ShapelessOreRecipe {
    private static int j = 0;

    public UpgradingRecipeShapeless(ItemStack result, Object ... recipe) {
        super(null, result, recipe);
        this.setRegistryName(new ResourceLocation("simplyjetpacks", "upgradeRecipeShapeless" + j));
        ++j;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        int ingredientCount = 0;
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            ++ingredientCount;
            items.add(itemstack);
        }
        if (ingredientCount != this.input.size()) {
            return false;
        }
        return RecipeMatcher.findMatches((List)items, (List)this.input) != null;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack inputStack = ItemStack.field_190927_a;
        ItemStack outputStack = this.output.func_77946_l();
        IEnergyContainerItem outputItem = (IEnergyContainerItem)outputStack.func_77973_b();
        int addedEnergy = 0;
        ParticleType particleType = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            inputStack = stack;
            if (inputStack.func_77973_b() instanceof IEnergyContainerItem) {
                addedEnergy += ((IEnergyContainerItem)inputStack.func_77973_b()).getEnergyStored(inputStack);
            } else if (OreDictionary.containsMatch((boolean)false, CommonProxy.oresListParticles, (ItemStack[])new ItemStack[]{inputStack})) {
                particleType = ParticleType.values()[inputStack.func_77952_i()];
            }
            if (!(stack.func_77973_b() instanceof ItemJetpack) && !(stack.func_77973_b() instanceof ItemFluxpack)) continue;
            ItemHelper.copyTag(outputStack, inputStack);
        }
        if (inputStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        NBTHelper.setInt(outputStack, "Energy", Math.min(addedEnergy, outputItem.getMaxEnergyStored(outputStack)));
        if (outputItem instanceof ItemJetpack && particleType != null) {
            ((ItemJetpack)outputItem).setParticleType(outputStack, particleType);
        }
        return outputStack;
    }

    public boolean func_192399_d() {
        return true;
    }
}

