/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.hocon.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.lucko.luckperms.lib.hocon.ConfigException;
import me.lucko.luckperms.lib.hocon.impl.AbstractConfigNodeValue;
import me.lucko.luckperms.lib.hocon.impl.AbstractConfigValue;
import me.lucko.luckperms.lib.hocon.impl.ConfigReference;
import me.lucko.luckperms.lib.hocon.impl.ConfigString;
import me.lucko.luckperms.lib.hocon.impl.Path;
import me.lucko.luckperms.lib.hocon.impl.PathParser;
import me.lucko.luckperms.lib.hocon.impl.SubstitutionExpression;
import me.lucko.luckperms.lib.hocon.impl.Token;
import me.lucko.luckperms.lib.hocon.impl.Tokens;

final class ConfigNodeSimpleValue
extends AbstractConfigNodeValue {
    final Token token;

    ConfigNodeSimpleValue(Token value) {
        this.token = value;
    }

    @Override
    protected Collection<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    protected Token token() {
        return this.token;
    }

    protected AbstractConfigValue value() {
        if (Tokens.isValue(this.token)) {
            return Tokens.getValue(this.token);
        }
        if (Tokens.isUnquotedText(this.token)) {
            return new ConfigString.Unquoted(this.token.origin(), Tokens.getUnquotedText(this.token));
        }
        if (Tokens.isSubstitution(this.token)) {
            List<Token> expression = Tokens.getSubstitutionPathExpression(this.token);
            Path path = PathParser.parsePathExpression(expression.iterator(), this.token.origin());
            boolean optional = Tokens.getSubstitutionOptional(this.token);
            return new ConfigReference(this.token.origin(), new SubstitutionExpression(path, optional));
        }
        throw new ConfigException.BugOrBroken("ConfigNodeSimpleValue did not contain a valid value token");
    }
}

