/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile;

import io.github.phantamanta44.libnine.capability.provider.CapabilityBroker;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockCore;
import io.github.phantamanta44.libnine.tile.RegisterTile;
import io.github.phantamanta44.threng.tile.TileBigAssemblerCore;
import io.github.phantamanta44.threng.tile.TileBigAssemblerPart;
import io.github.phantamanta44.threng.tile.TileBigAssemblerPatternStore;
import io.github.phantamanta44.threng.util.ConjoinedItemHandler;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

@RegisterTile(value="threng")
public class TileBigAssemblerIoPort
extends TileBigAssemblerPart {
    private final BigAssemblerIoHandler ioHandler = new BigAssemblerIoHandler();

    public TileBigAssemblerIoPort() {
        this.multiBlock.onConnectionStatusChange(this.ioHandler::invalidateCache);
    }

    protected ICapabilityProvider initCapabilities() {
        return new CapabilityBroker().with(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)this.ioHandler);
    }

    private class BigAssemblerIoHandler
    implements IItemHandler {
        @Nullable
        private IItemHandler cachedItemHandler = null;

        private BigAssemblerIoHandler() {
        }

        void invalidateCache() {
            this.cachedItemHandler = null;
        }

        private IItemHandler getItemHandler() {
            if (this.cachedItemHandler == null) {
                MultiBlockCore core = TileBigAssemblerIoPort.this.multiBlock.getCore();
                this.cachedItemHandler = core != null ? new ConjoinedItemHandler(((TileBigAssemblerCore)core.getUnit()).getPatternStores().stream().map(TileBigAssemblerPatternStore::getPatternInventory).collect(Collectors.toList())) : new EmptyHandler();
            }
            return this.cachedItemHandler;
        }

        public int getSlots() {
            return this.getItemHandler().getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.getItemHandler().getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.getItemHandler().insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.getItemHandler().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.getItemHandler().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.getItemHandler().isItemValid(slot, stack);
        }
    }
}

