/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.util.AEPartLocation;
import appeng.block.AEBaseTileBlock;
import appeng.block.storage.DriveSlotState;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.GuiBridge;
import appeng.tile.storage.TileChest;
import appeng.util.Platform;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChest
extends AEBaseTileBlock {
    private static final PropertyEnum<DriveSlotState> SLOT_STATE = PropertyEnum.func_177709_a((String)"slot_state", DriveSlotState.class);

    public BlockChest() {
        super(Material.field_151573_f);
        this.func_180632_j(this.func_176223_P().func_177226_a(SLOT_STATE, (Comparable)((Object)DriveSlotState.EMPTY)));
    }

    @Override
    protected IProperty[] getAEStates() {
        return new IProperty[]{SLOT_STATE};
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        DriveSlotState slotState = DriveSlotState.EMPTY;
        TileChest te = (TileChest)this.getTileEntity(worldIn, pos);
        if (te != null) {
            if (te.getCellCount() >= 1) {
                slotState = DriveSlotState.fromCellStatus(te.getCellStatus(0));
            }
            if (!te.isPowered() && slotState != DriveSlotState.EMPTY) {
                slotState = DriveSlotState.OFFLINE;
            }
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a(SLOT_STATE, (Comparable)((Object)slotState));
    }

    @Override
    public boolean onActivated(World w, BlockPos pos, EntityPlayer p, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileChest tg = (TileChest)this.getTileEntity((IBlockAccess)w, pos);
        if (tg != null && !p.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            if (side != tg.getUp()) {
                Platform.openGUI(p, tg, AEPartLocation.fromFacing(side), GuiBridge.GUI_CHEST);
            } else if (!tg.openGui(p)) {
                p.func_145747_a(PlayerMessages.ChestCannotReadStorageCell.get());
            }
            return true;
        }
        return false;
    }
}

