/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.util.helpers.ItemHandlerUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class WrapperChainedItemHandler
implements IItemHandlerModifiable {
    private IItemHandler[] itemHandler;
    private int[] baseIndex;
    private int slotCount;

    public WrapperChainedItemHandler(IItemHandler ... itemHandler) {
        this.setItemHandlers(itemHandler);
    }

    private void setItemHandlers(IItemHandler[] handlers) {
        this.itemHandler = handlers;
        this.baseIndex = new int[this.itemHandler.length];
        int index = 0;
        for (int i = 0; i < this.itemHandler.length; ++i) {
            this.baseIndex[i] = index += this.itemHandler[i].getSlots();
        }
        this.slotCount = index;
    }

    private int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    private IItemHandler getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.itemHandler.length) {
            return EmptyHandler.INSTANCE;
        }
        return this.itemHandler[index];
    }

    private int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndex.length) {
            return slot;
        }
        return slot - this.baseIndex[index - 1];
    }

    public void cycleOrder() {
        if (this.itemHandler.length > 1) {
            ArrayList<IItemHandler> newOrder = new ArrayList<IItemHandler>();
            newOrder.add(this.itemHandler[this.itemHandler.length - 1]);
            for (int i = 0; i < this.itemHandler.length - 1; ++i) {
                newOrder.add(this.itemHandler[i]);
            }
            this.setItemHandlers(newOrder.toArray(new IItemHandler[this.itemHandler.length]));
        }
    }

    public int getSlots() {
        return this.slotCount;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int index = this.getIndexForSlot(slot);
        IItemHandler handler = this.getHandlerFromIndex(index);
        int targetSlot = this.getSlotFromIndex(slot, index);
        return handler.getStackInSlot(targetSlot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int index = this.getIndexForSlot(slot);
        IItemHandler handler = this.getHandlerFromIndex(index);
        int targetSlot = this.getSlotFromIndex(slot, index);
        return handler.insertItem(targetSlot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int index = this.getIndexForSlot(slot);
        IItemHandler handler = this.getHandlerFromIndex(index);
        int targetSlot = this.getSlotFromIndex(slot, index);
        return handler.extractItem(targetSlot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        int index = this.getIndexForSlot(slot);
        IItemHandler handler = this.getHandlerFromIndex(index);
        int localSlot = this.getSlotFromIndex(slot, index);
        return handler.getSlotLimit(localSlot);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int index = this.getIndexForSlot(slot);
        IItemHandler handler = this.getHandlerFromIndex(index);
        int targetSlot = this.getSlotFromIndex(slot, index);
        ItemHandlerUtil.setStackInSlot(handler, targetSlot, stack);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        int index = this.getIndexForSlot(slot);
        IItemHandler handler = this.getHandlerFromIndex(index);
        int targetSlot = this.getSlotFromIndex(slot, index);
        return handler.isItemValid(targetSlot, stack);
    }
}

