/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.commands;

import forestry.api.mail.ITradeStation;
import forestry.api.mail.ITradeStationInfo;
import forestry.api.mail.PostManager;
import forestry.core.commands.CommandHelpers;
import forestry.core.commands.SubCommand;
import forestry.core.utils.StringUtil;
import forestry.mail.MailAddress;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class CommandMail
extends SubCommand {
    public CommandMail() {
        super("mail");
        this.addChildCommand(new CommandMailTrades());
        this.addChildCommand(new CommandMailVirtualize());
        this.addAlias("ml");
    }

    public static class CommandMailVirtualize
    extends SubCommand {
        public CommandMailVirtualize() {
            super("virtualize");
            this.addAlias("virt");
            this.setPermLevel(SubCommand.PermLevel.ADMIN);
        }

        @Override
        public void executeSubCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            MailAddress address;
            World world;
            ITradeStation trade;
            if (args.length != 1) {
                CommandHelpers.throwWrongUsage(sender, this);
            }
            if ((trade = PostManager.postRegistry.getTradeStation(world = sender.func_130014_f_(), address = new MailAddress(args[0]))) == null) {
                Style red = new Style();
                red.func_150238_a(TextFormatting.RED);
                CommandHelpers.sendLocalizedChatMessage(sender, red, "for.chat.command.forestry.mail.virtualize.no_tradestation", args[0]);
                return;
            }
            trade.setVirtual(!trade.isVirtual());
            Style green = new Style();
            green.func_150238_a(TextFormatting.GREEN);
            CommandHelpers.sendLocalizedChatMessage(sender, green, "for.chat.command.forestry.mail.virtualize.set", trade.getAddress().getName(), trade.isVirtual());
        }
    }

    public static class CommandMailTrades
    extends SubCommand {
        public CommandMailTrades() {
            super("trades");
            this.addAlias("tr");
        }

        @Override
        public void executeSubCommand(MinecraftServer server, ICommandSender sender, String[] args) {
            if (!(sender instanceof EntityPlayer)) {
                return;
            }
            for (ITradeStation trade : PostManager.postRegistry.getPostOffice(((EntityPlayer)sender).field_70170_p).getActiveTradeStations(((EntityPlayer)sender).field_70170_p).values()) {
                CommandHelpers.sendChatMessage(sender, CommandMailTrades.makeTradeListEntry(trade.getTradeInfo()));
            }
        }

        private static String makeTradeListEntry(ITradeStationInfo info) {
            TextFormatting formatting = info.getState().isOk() ? TextFormatting.GREEN : TextFormatting.RED;
            String tradegood = "[ ? ]";
            if (!info.getTradegood().func_190926_b()) {
                tradegood = info.getTradegood().func_190916_E() + "x" + info.getTradegood().func_82833_r();
            }
            String demand = "[ ? ]";
            if (!info.getRequired().isEmpty()) {
                demand = "";
                for (ItemStack dmd : info.getRequired()) {
                    demand = StringUtil.append(", ", demand, dmd.func_190916_E() + "x" + dmd.func_82833_r());
                }
            }
            return String.format("%s%-12s | %-20s | %s", formatting, info.getAddress().getName(), tradegood, demand);
        }
    }
}

