/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class RegionCache
implements IBlockAccess {
    private final BlockPos center;
    private final int radius;
    private WeakReference<IBlockAccess> passthrough;
    private final Long2ObjectMap<IBlockState> stateCache = new Long2ObjectOpenHashMap();

    public RegionCache(BlockPos center, int radius, @Nullable IBlockAccess passthrough) {
        this.center = center;
        this.radius = radius;
        this.passthrough = new WeakReference<IBlockAccess>(passthrough);
    }

    private IBlockAccess getPassthrough() {
        IBlockAccess ret = (IBlockAccess)this.passthrough.get();
        Preconditions.checkNotNull((Object)ret);
        return ret;
    }

    @Nonnull
    public RegionCache updateWorld(IBlockAccess passthrough) {
        if (this.passthrough.get() != passthrough) {
            this.stateCache.clear();
        }
        this.passthrough = new WeakReference<IBlockAccess>(passthrough);
        return this;
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.getPassthrough().func_175625_s(pos);
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        return this.getPassthrough().func_175626_b(pos, lightValue);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        long address = pos.func_177986_g();
        IBlockState ret = (IBlockState)this.stateCache.get(address);
        if (ret == null) {
            ret = this.getPassthrough().func_180495_p(pos);
            this.stateCache.put(address, (Object)ret);
        }
        return ret;
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.getPassthrough().func_180494_b(pos);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.getPassthrough().func_175627_a(pos, direction);
    }

    public WorldType func_175624_G() {
        return this.getPassthrough().func_175624_G();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.getPassthrough().isSideSolid(pos, side, _default);
    }
}

