/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.compat.jei;

import com.google.common.collect.Lists;
import cubex2.cs4.api.WrappedItemStack;
import cubex2.cs4.compat.jei.BaseRecipeCategory;
import cubex2.cs4.compat.jei.CraftingRecipeCategory;
import cubex2.cs4.compat.jei.DelegatedMachineRecipe;
import cubex2.cs4.compat.jei.MachineRecipeCategory;
import cubex2.cs4.compat.jei.MachineRecipeWrapper;
import cubex2.cs4.compat.jei.ShapedRecipeWrapper;
import cubex2.cs4.compat.jei.ShapelessRecipeWrapper;
import cubex2.cs4.compat.jei.TransferInfo;
import cubex2.cs4.plugins.jei.JEICompatRegistry;
import cubex2.cs4.plugins.jei.JEICraftingRecipe;
import cubex2.cs4.plugins.jei.JEIDescription;
import cubex2.cs4.plugins.jei.JEIMachineRecipe;
import cubex2.cs4.plugins.jei.JEIRecipe;
import cubex2.cs4.plugins.vanilla.DamageableShapedOreRecipe;
import cubex2.cs4.plugins.vanilla.DamageableShapelessOreRecipe;
import cubex2.cs4.plugins.vanilla.crafting.CraftingManagerCS4;
import cubex2.cs4.plugins.vanilla.crafting.MachineManager;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipe;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipeOutput;
import cubex2.cs4.plugins.vanilla.tileentity.TileEntityModuleCrafting;
import cubex2.cs4.plugins.vanilla.tileentity.TileEntityModuleMachine;
import cubex2.cs4.util.ReflectionHelper;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class CS4JEIPlugin
implements IModPlugin {
    private List<CraftingRecipeCategory> craftingCategories = Lists.newArrayList();
    private List<MachineRecipeCategory> machineCategories = Lists.newArrayList();

    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        this.addMachineRecipes(registry, jeiHelpers);
        this.addCraftingRecipes(registry, jeiHelpers);
        this.addDescriptions(registry);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        BaseRecipeCategory category;
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        for (JEICraftingRecipe jEICraftingRecipe : JEICompatRegistry.craftingRecipes) {
            category = new CraftingRecipeCategory(jEICraftingRecipe, jeiHelpers.getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{category});
            this.craftingCategories.add((CraftingRecipeCategory)category);
        }
        for (JEIMachineRecipe jEIMachineRecipe : JEICompatRegistry.machineRecipes) {
            category = new MachineRecipeCategory(jEIMachineRecipe, jeiHelpers.getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{category});
            this.machineCategories.add((MachineRecipeCategory)category);
        }
    }

    private void addCraftingRecipes(IModRegistry registry, IJeiHelpers jeiHelpers) {
        IRecipeWrapperFactory shapedFactory = recipe -> new ShapedRecipeWrapper((DamageableShapedOreRecipe)((Object)recipe), jeiHelpers);
        IRecipeWrapperFactory shapelessFactory = recipe -> new ShapelessRecipeWrapper((DamageableShapelessOreRecipe)((Object)recipe), jeiHelpers);
        for (CraftingRecipeCategory category : this.craftingCategories) {
            JEICraftingRecipe recipe2 = (JEICraftingRecipe)category.getRecipe();
            String uid = recipe2.getUid();
            registry.handleRecipes(JEICompatRegistry.getShapedCraftingRecipeClass(recipe2.recipeList), shapedFactory, uid);
            registry.handleRecipes(JEICompatRegistry.getShapelessCraftingRecipeClass(recipe2.recipeList), shapelessFactory, uid);
            registry.addRecipes(CraftingManagerCS4.getRecipes(recipe2.recipeList), uid);
            this.addCommonEntries(registry, recipe2, category.getModuleName(), ((TileEntityModuleCrafting.Supplier)category.getModule()).rows * ((TileEntityModuleCrafting.Supplier)category.getModule()).columns);
        }
    }

    private void addMachineRecipes(IModRegistry registry, IJeiHelpers jeiHelpers) {
        IRecipeWrapperFactory factory = recipe -> new MachineRecipeWrapper(recipe.recipe, recipe.usedOutput, jeiHelpers);
        for (MachineRecipeCategory category : this.machineCategories) {
            JEIMachineRecipe recipe2 = (JEIMachineRecipe)category.getRecipe();
            String uid = recipe2.getUid();
            Class<? extends DelegatedMachineRecipe> delegatedRecipeClass = JEICompatRegistry.getDelegatedMachineRecipeClass(recipe2.recipeList);
            registry.handleRecipes(delegatedRecipeClass, factory, uid);
            for (MachineRecipe machineRecipe : MachineManager.getRecipes(recipe2.recipeList)) {
                for (MachineRecipeOutput output : machineRecipe.getOutputs()) {
                    DelegatedMachineRecipe delegatedRecipe = ReflectionHelper.newInstance(delegatedRecipeClass);
                    delegatedRecipe.recipe = machineRecipe;
                    delegatedRecipe.usedOutput = output;
                    registry.addRecipes(Collections.singletonList(delegatedRecipe), uid);
                }
            }
            this.addCommonEntries(registry, recipe2, category.getModuleName(), ((TileEntityModuleMachine.Supplier)category.getModule()).inputSlots);
        }
    }

    private void addCommonEntries(IModRegistry registry, JEIRecipe recipe, String moduleName, int inputSlots) {
        if (recipe.icon != null) {
            registry.addRecipeCatalyst((Object)recipe.icon.getItemStack(), new String[]{recipe.getUid()});
        }
        if (recipe.recipeAreaWidth > 0 && recipe.recipeAreaHeight > 0) {
            registry.addRecipeClickArea(recipe.getGui().getGuiClass(), recipe.recipeAreaX, recipe.recipeAreaY, recipe.recipeAreaWidth, recipe.recipeAreaHeight, new String[]{recipe.getUid()});
        }
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new TransferInfo(recipe.getUid(), moduleName, inputSlots));
    }

    private void addDescriptions(IModRegistry registry) {
        for (JEIDescription description : JEICompatRegistry.descriptions) {
            List items = description.items.stream().map(WrappedItemStack::getItemStack).map(ItemStack::func_77946_l).collect(Collectors.toList());
            registry.addIngredientInfo(items, ItemStack.class, description.desc);
        }
    }
}

