/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Maps;
import cubex2.cs4.api.WrappedArmorMaterial;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemArmor;

public class WrappedArmorMaterialImpl
implements WrappedArmorMaterial {
    public final String name;
    private ItemArmor.ArmorMaterial material;
    private static final Map<String, ItemArmor.ArmorMaterial> vanillaMaterials = Maps.newHashMap();

    public WrappedArmorMaterialImpl(String name) {
        this.name = name.toLowerCase();
    }

    @Override
    @Nullable
    public ItemArmor.ArmorMaterial getArmorMaterial() {
        if (this.material != null) {
            return this.material;
        }
        if (vanillaMaterials.containsKey(this.name)) {
            this.material = vanillaMaterials.get(this.name);
        } else {
            for (ItemArmor.ArmorMaterial mat : ItemArmor.ArmorMaterial.values()) {
                if (!mat.name().equalsIgnoreCase(this.name)) continue;
                this.material = mat;
                break;
            }
        }
        return this.material;
    }

    static {
        vanillaMaterials.put("leather", ItemArmor.ArmorMaterial.LEATHER);
        vanillaMaterials.put("chain", ItemArmor.ArmorMaterial.CHAIN);
        vanillaMaterials.put("iron", ItemArmor.ArmorMaterial.IRON);
        vanillaMaterials.put("gold", ItemArmor.ArmorMaterial.GOLD);
        vanillaMaterials.put("diamond", ItemArmor.ArmorMaterial.DIAMOND);
    }
}

