/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.recipe;

import com.google.common.collect.Lists;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.crafting.IAdvRecipe;
import ic2.api.classic.recipe.crafting.ICraftingRecipeList;
import ic2.api.recipe.IRecipeInput;
import ic2.core.item.recipe.AdvRecipe;
import ic2.core.item.recipe.AdvShapelessRecipe;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.lib.recipe.RecipeAttributes;
import wanion.lib.recipe.RecipeHelper;
import wanion.unidict.common.Util;
import wanion.unidict.recipe.AbstractRecipeResearcher;
import wanion.unidict.resource.UniResourceContainer;

public class IC2CRecipeResearcher
extends AbstractRecipeResearcher<AdvRecipe, AdvShapelessRecipe> {
    private final Item craftingHammer = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ic2c_extras", "craftinghammer"));
    private final Field shapelessInput;
    private final Field shapedInput;

    public IC2CRecipeResearcher() {
        try {
            this.shapelessInput = AdvShapelessRecipe.class.getDeclaredField("input");
            this.shapelessInput.setAccessible(true);
            this.shapedInput = AdvRecipe.class.getDeclaredField("input");
            this.shapedInput.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Couldn't find IC2C fields.");
        }
    }

    public int getShapedRecipeKey(@Nonnull AdvRecipe advRecipe) {
        if (advRecipe.isInvisible()) {
            return 0;
        }
        TIntList recipeKeys = Util.getList(advRecipe.func_192400_c(), this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    public int getShapelessRecipeKey(@Nonnull AdvShapelessRecipe advShapelessRecipe) {
        if (advShapelessRecipe.isInvisible()) {
            return 0;
        }
        TIntList recipeKeys = Util.getList(advShapelessRecipe.func_192400_c(), this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Nonnull
    public List<Class<? extends AdvRecipe>> getShapedRecipeClasses() {
        return Collections.singletonList(AdvRecipe.class);
    }

    @Nonnull
    public List<Class<? extends AdvShapelessRecipe>> getShapelessRecipeClasses() {
        return Collections.singletonList(AdvShapelessRecipe.class);
    }

    public ShapedOreRecipe getNewShapedRecipe(@Nonnull AdvRecipe recipe) {
        Object[] newRecipeInputs = this.getNewShapedRecipeInputs(recipe);
        UniResourceContainer outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b());
        if (outputContainer == null) {
            return null;
        }
        int outputSize = recipe.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        RecipeAttributes newRecipeAttributes = RecipeHelper.rawShapeToShape((Object[])newRecipeInputs);
        return new ShapedOreRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_shape." + newRecipeAttributes.shape), outputStack, newRecipeAttributes.actualShape);
    }

    public ShapedOreRecipe getNewShapedFromShapelessRecipe(@Nonnull AdvShapelessRecipe recipe) {
        try {
            UniResourceContainer outputContainer;
            int i;
            Object[] newRecipeInputs = new Object[9];
            List recipeInputs = (List)this.shapelessInput.get(recipe);
            if (itemStacksOnly) {
                for (i = 0; i < recipeInputs.size(); ++i) {
                    List inputs = ((IRecipeInput)recipeInputs.get(i)).getInputs();
                    if (inputs.isEmpty()) continue;
                    newRecipeInputs[i] = this.resourceHandler.getMainItemStack((ItemStack)inputs.get(0));
                }
            } else {
                for (i = 0; i < recipeInputs.size(); ++i) {
                    String oreName;
                    IRecipeInput input = (IRecipeInput)recipeInputs.get(i);
                    String string = oreName = input instanceof RecipeInputOreDict ? ((RecipeInputOreDict)input).input : null;
                    if (oreName == null) {
                        boolean notEmpty = !input.getInputs().isEmpty();
                        String string2 = oreName = notEmpty ? this.uniOreDictionary.getName(input.getInputs().get(0)) : null;
                        if (oreName != null) {
                            newRecipeInputs[i] = oreName;
                            continue;
                        }
                        if (!notEmpty) continue;
                        newRecipeInputs[i] = input.getInputs().get(0);
                        continue;
                    }
                    newRecipeInputs[i] = oreName;
                }
            }
            if ((outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b())) == null) {
                return null;
            }
            int outputSize = recipe.func_77571_b().func_190916_E();
            ItemStack outputStack = outputContainer.getMainEntry(outputSize);
            RecipeAttributes newRecipeAttributes = RecipeHelper.rawShapeToShape((Object[])newRecipeInputs);
            return new ShapedOreRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_shape." + newRecipeAttributes.shape), outputStack, newRecipeAttributes.actualShape);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ShapelessOreRecipe getNewShapelessRecipe(@Nonnull AdvShapelessRecipe recipe) {
        List<Object> newInputs = this.getNewShapelessRecipeInputs(recipe);
        UniResourceContainer outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b());
        if (outputContainer == null) {
            return null;
        }
        int outputSize = recipe.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        return new ShapelessOreRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_size." + newInputs.size()), outputStack, newInputs.toArray());
    }

    public ShapelessOreRecipe getNewShapelessFromShapedRecipe(@Nonnull AdvRecipe recipe) {
        try {
            UniResourceContainer outputContainer;
            ArrayList<Object> newInputs = new ArrayList<Object>();
            IRecipeInput[] input = (IRecipeInput[])this.shapedInput.get(recipe);
            if (itemStacksOnly) {
                for (IRecipeInput recipeInput : input) {
                    List inputs = recipeInput.getInputs();
                    if (inputs.isEmpty()) continue;
                    newInputs.add(this.resourceHandler.getMainItemStack((ItemStack)inputs.get(0)));
                }
            } else {
                for (IRecipeInput recipeInput : input) {
                    String oreName;
                    String string = oreName = recipeInput instanceof RecipeInputOreDict ? ((RecipeInputOreDict)recipeInput).input : null;
                    if (oreName == null) {
                        boolean notEmpty = !recipeInput.getInputs().isEmpty();
                        String string2 = oreName = notEmpty ? this.uniOreDictionary.getName(recipeInput.getInputs().get(0)) : null;
                        if (oreName != null) {
                            newInputs.add(oreName);
                            continue;
                        }
                        if (!notEmpty) continue;
                        newInputs.add(recipeInput.getInputs().get(0));
                        continue;
                    }
                    newInputs.add(oreName);
                }
            }
            if ((outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b())) == null) {
                return null;
            }
            int outputSize = recipe.func_77571_b().func_190916_E();
            ItemStack outputStack = outputContainer.getMainEntry(outputSize);
            return new ShapelessOreRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_size." + newInputs.size()), outputStack, newInputs.toArray());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Object> getNewShapelessRecipeInputs(AdvShapelessRecipe advRecipe) {
        ArrayList<Object> newInputs = new ArrayList<Object>();
        try {
            List input = (List)this.shapelessInput.get(advRecipe);
            if (itemStacksOnly) {
                for (IRecipeInput recipeInput : input) {
                    List inputs = recipeInput.getInputs();
                    if (inputs.isEmpty()) continue;
                    newInputs.add(this.resourceHandler.getMainItemStack((ItemStack)inputs.get(0)));
                }
            } else {
                for (IRecipeInput recipeInput : input) {
                    String oreName;
                    String string = oreName = recipeInput instanceof RecipeInputOreDict ? ((RecipeInputOreDict)recipeInput).input : null;
                    if (oreName == null) {
                        boolean notEmpty = !recipeInput.getInputs().isEmpty();
                        String string2 = oreName = notEmpty ? this.uniOreDictionary.getName(recipeInput.getInputs().get(0)) : null;
                        if (oreName != null) {
                            newInputs.add(oreName);
                            continue;
                        }
                        if (!notEmpty) continue;
                        newInputs.add(recipeInput.getInputs().get(0));
                        continue;
                    }
                    if (oreName.equals("craftingToolForgeHammer") && this.craftingHammer != null) {
                        newInputs.add(new ItemStack(this.craftingHammer, 1, Short.MAX_VALUE));
                        continue;
                    }
                    newInputs.add(oreName);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return newInputs;
    }

    private Object[] getNewShapedRecipeInputs(AdvRecipe advRecipe) {
        int width = advRecipe.getRecipeLength();
        int height = advRecipe.getRecipeHeight();
        int root = Math.max(width, height);
        Object[] newRecipeInputs = new Object[root * root];
        try {
            IRecipeInput[] recipeInputs = (IRecipeInput[])this.shapedInput.get(advRecipe);
            int i = 0;
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    if (i < recipeInputs.length) {
                        if (itemStacksOnly) {
                            List inputs = recipeInputs[i].getInputs();
                            if (!inputs.isEmpty()) {
                                newRecipeInputs[y * root + x] = this.resourceHandler.getMainItemStack((ItemStack)inputs.get(0));
                            }
                        } else {
                            String oreName;
                            IRecipeInput input = recipeInputs[i];
                            String string = oreName = input instanceof RecipeInputOreDict ? ((RecipeInputOreDict)input).input : null;
                            if (oreName == null) {
                                boolean notEmpty = input != null && !input.getInputs().isEmpty();
                                String string2 = oreName = notEmpty ? this.uniOreDictionary.getName(input.getInputs().get(0)) : null;
                                if (oreName != null) {
                                    newRecipeInputs[y * root + x] = oreName;
                                } else if (notEmpty) {
                                    newRecipeInputs[y * root + x] = input.getInputs().get(0);
                                }
                            } else {
                                newRecipeInputs[y * root + x] = oreName;
                            }
                        }
                    }
                    ++x;
                    ++i;
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return newRecipeInputs;
    }

    @Override
    public void postProcess() {
        ICraftingRecipeList advCrafting = ClassicRecipes.advCrafting;
        List advRecipeList = advCrafting.getRecipes();
        HashMap<AdvShapelessRecipe, ItemStack> shapelessStackMap = new HashMap<AdvShapelessRecipe, ItemStack>();
        HashMap<AdvRecipe, ItemStack> shapedStackMap = new HashMap<AdvRecipe, ItemStack>();
        for (IAdvRecipe advRecipe : advRecipeList) {
            AdvRecipe shapedRecipe2;
            ItemStack newOutput2;
            ItemStack output;
            if (advRecipe == null || !advRecipe.isInvisible()) continue;
            if (advRecipe instanceof AdvShapelessRecipe) {
                AdvShapelessRecipe shapelessRecipe2 = (AdvShapelessRecipe)advRecipe;
                output = shapelessRecipe2.func_77571_b();
                if (output == (newOutput2 = this.resourceHandler.getMainItemStack(output))) continue;
                shapelessStackMap.put(shapelessRecipe2, newOutput2);
                continue;
            }
            if (!(advRecipe instanceof AdvRecipe) || (output = (shapedRecipe2 = (AdvRecipe)advRecipe).func_77571_b()) == (newOutput2 = this.resourceHandler.getMainItemStack(output))) continue;
            shapedStackMap.put(shapedRecipe2, newOutput2);
        }
        shapelessStackMap.forEach((shapelessRecipe, newOutput) -> {
            List<Object> newShapelessInputs = this.getNewShapelessRecipeInputs((AdvShapelessRecipe)shapelessRecipe);
            newShapelessInputs.add(true);
            advCrafting.overrideShapelessRecipe(shapelessRecipe.getRecipeID(), newOutput, newShapelessInputs.toArray());
        });
        shapedStackMap.forEach((shapedRecipe, newOutput) -> {
            ArrayList newShapedInputs = Lists.newArrayList((Object[])RecipeHelper.rawShapeToShape((Object[])this.getNewShapedRecipeInputs((AdvRecipe)shapedRecipe)).actualShape);
            newShapedInputs.add(true);
            advCrafting.overrideRecipe(shapedRecipe.getRecipeID(), newOutput, newShapedInputs.toArray());
        });
    }
}

