/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json;

import alexiil.mc.mod.load.baked.insn.BakedColourFunctional;
import alexiil.mc.mod.load.baked.insn.BakedColourFunctionalTogether;
import alexiil.mc.mod.load.baked.insn.BakedColourSimple;
import alexiil.mc.mod.load.baked.insn.BakedInsn;
import alexiil.mc.mod.load.baked.insn.BakedRotationFunctional;
import alexiil.mc.mod.load.baked.insn.BakedRotationSimple;
import alexiil.mc.mod.load.baked.insn.BakedScaleFunctional;
import alexiil.mc.mod.load.baked.insn.BakedScaleSimple;
import alexiil.mc.mod.load.baked.insn.BakedTranslateFunctional;
import alexiil.mc.mod.load.baked.insn.BakedTranslateSimple;
import alexiil.mc.mod.load.json.JsonConfigurable;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionContext;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.GenericExpressionCompiler;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeConstantDouble;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeConstantLong;

public abstract class JsonInsn
extends JsonConfigurable<JsonInsn, BakedInsn> {

    public static class JsonInsnTranslate
    extends JsonInsn {
        public final String x;
        public final String y;
        public final String z;

        public JsonInsnTranslate(String x, String y, String z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public BakedInsn actuallyBake(FunctionContext context) throws InvalidExpressionException {
            IExpressionNode.INodeDouble _x = GenericExpressionCompiler.compileExpressionDouble(this.x, context);
            IExpressionNode.INodeDouble _y = GenericExpressionCompiler.compileExpressionDouble(this.y, context);
            IExpressionNode.INodeDouble _z = GenericExpressionCompiler.compileExpressionDouble(this.z, context);
            if (_x instanceof NodeConstantDouble && _y instanceof NodeConstantDouble && _z instanceof NodeConstantDouble) {
                return new BakedTranslateSimple(_x.evaluate(), _y.evaluate(), _z.evaluate());
            }
            return new BakedTranslateFunctional(_x, _y, _z);
        }
    }

    public static class JsonInsnColourTogether
    extends JsonInsn {
        public final String argb;

        public JsonInsnColourTogether(String argb) {
            this.argb = argb;
            this.setSource(argb);
        }

        @Override
        public BakedInsn actuallyBake(FunctionContext context) throws InvalidExpressionException {
            IExpressionNode.INodeLong _argb = GenericExpressionCompiler.compileExpressionLong(this.argb, context);
            if (_argb instanceof NodeConstantLong) {
                long value = ((NodeConstantLong)_argb).value;
                float a = (float)(value >> 24 & 0xFFL) / 255.0f;
                float r = (float)(value >> 16 & 0xFFL) / 255.0f;
                float g = (float)(value >> 8 & 0xFFL) / 255.0f;
                float b = (float)(value & 0xFFL) / 255.0f;
                return new BakedColourSimple(a, r, g, b);
            }
            return new BakedColourFunctionalTogether(_argb);
        }
    }

    public static class JsonInsnColourSplit
    extends JsonInsn {
        public final String a;
        public final String r;
        public final String g;
        public final String b;

        public JsonInsnColourSplit(String a, String r, String g, String b) {
            this.a = a;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        @Override
        public BakedInsn actuallyBake(FunctionContext functions) throws InvalidExpressionException {
            IExpressionNode.INodeDouble _a = GenericExpressionCompiler.compileExpressionDouble(this.a, functions);
            IExpressionNode.INodeDouble _r = GenericExpressionCompiler.compileExpressionDouble(this.r, functions);
            IExpressionNode.INodeDouble _g = GenericExpressionCompiler.compileExpressionDouble(this.g, functions);
            IExpressionNode.INodeDouble _b = GenericExpressionCompiler.compileExpressionDouble(this.b, functions);
            if (_a instanceof NodeConstantDouble && _r instanceof NodeConstantDouble && _g instanceof NodeConstantDouble && _b instanceof NodeConstantDouble) {
                return new BakedColourSimple((float)_a.evaluate(), (float)_r.evaluate(), (float)_g.evaluate(), (float)_b.evaluate());
            }
            return new BakedColourFunctional(_a, _r, _g, _b);
        }
    }

    public static class JsonInsnScale
    extends JsonInsn {
        public final String x;
        public final String y;
        public final String z;

        public JsonInsnScale(String x, String y, String z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public BakedInsn actuallyBake(FunctionContext functions) throws InvalidExpressionException {
            IExpressionNode.INodeDouble _x = GenericExpressionCompiler.compileExpressionDouble(this.x, functions);
            IExpressionNode.INodeDouble _y = GenericExpressionCompiler.compileExpressionDouble(this.y, functions);
            IExpressionNode.INodeDouble _z = GenericExpressionCompiler.compileExpressionDouble(this.z, functions);
            if (_x instanceof NodeConstantDouble && _y instanceof NodeConstantDouble && _z instanceof NodeConstantDouble) {
                return new BakedScaleSimple(_x.evaluate(), _y.evaluate(), _z.evaluate());
            }
            return new BakedScaleFunctional(_x, _y, _z);
        }
    }

    public static class JsonInsnRotate
    extends JsonInsn {
        public final String angle;
        public final String x;
        public final String y;
        public final String z;

        public JsonInsnRotate(String angle, String x, String y, String z) {
            this.angle = angle;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public BakedInsn actuallyBake(FunctionContext functions) throws InvalidExpressionException {
            IExpressionNode.INodeDouble _a = GenericExpressionCompiler.compileExpressionDouble(this.angle, functions);
            IExpressionNode.INodeDouble _x = GenericExpressionCompiler.compileExpressionDouble(this.x, functions);
            IExpressionNode.INodeDouble _y = GenericExpressionCompiler.compileExpressionDouble(this.y, functions);
            IExpressionNode.INodeDouble _z = GenericExpressionCompiler.compileExpressionDouble(this.z, functions);
            if (_a instanceof NodeConstantDouble && _x instanceof NodeConstantDouble && _y instanceof NodeConstantDouble && _z instanceof NodeConstantDouble) {
                return new BakedRotationSimple(_a.evaluate(), _x.evaluate(), _y.evaluate(), _z.evaluate());
            }
            return new BakedRotationFunctional(_a, _x, _y, _z);
        }
    }
}

