/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json.serial;

import alexiil.mc.mod.load.json.ConfigManager;
import alexiil.mc.mod.load.json.JsonFactory;
import alexiil.mc.mod.load.json.serial.IThrowingDeserialiser;
import alexiil.mc.mod.load.json.subtypes.JsonFactoryVariableChange;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;

public enum FactoryDeserialiser implements IThrowingDeserialiser<JsonFactory>
{
    INSTANCE;

    private static final JsonPrimitive BUILTIN_CHANGE;

    @Override
    public JsonFactory deserialize0(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws InvalidExpressionException {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("parent")) {
                JsonFactory factory = FactoryDeserialiser.deserialise0(context, obj);
                factory.setSource((JsonElement)obj);
                return factory;
            }
            throw new JsonSyntaxException("Expected either a builtin parent, or a known existing parent!");
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive prim = json.getAsJsonPrimitive();
            if (prim.isString()) {
                return ConfigManager.getAsFactory(prim.getAsString());
            }
            throw new JsonSyntaxException("Expected an object or a string, found " + prim);
        }
        throw new JsonSyntaxException("Expected an object or a string, found " + json);
    }

    private static JsonFactory deserialise0(JsonDeserializationContext context, JsonObject obj) {
        JsonElement pe = obj.get("parent");
        if (BUILTIN_CHANGE.equals((Object)pe)) {
            return new JsonFactoryVariableChange(null, obj, context);
        }
        JsonFactory parent = (JsonFactory)context.deserialize(pe, JsonFactory.class);
        if (parent instanceof JsonFactoryVariableChange) {
            return new JsonFactoryVariableChange((JsonFactoryVariableChange)parent, obj, context);
        }
        throw new IllegalStateException("Unknown JsonFactory " + parent.getClass());
    }

    static {
        BUILTIN_CHANGE = new JsonPrimitive("builtin/change");
    }
}

