/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.render;

import alexiil.mc.mod.load.CLSLog;
import alexiil.mc.mod.load.baked.BakedConfig;
import alexiil.mc.mod.load.baked.BakedRenderingPart;
import alexiil.mc.mod.load.render.TextureLoader;
import com.google.common.collect.ImmutableList;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class TextureAnimator {
    private static final int TEXTURE_MILLI_SECONDS = 16384;
    private static final int TEXTURE_PIXEL_CAP = 39321600;
    private static final int TEXTURE_PIXEL_MIN = 204800;
    private static final int TEXTURE_UPLOAD_AHEAD = 10;
    private static final int BUFFER_SIZE = 0x400000;
    private static final IntBuffer DATA_BUFFER = GLAllocation.func_74527_f((int)0x400000);
    private Map<String, AnimatedTexture> animatedTextures = new HashMap<String, AnimatedTexture>();
    private long now = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static boolean isAnimated(String resourceLocation) {
        location = new ResourceLocation(resourceLocation);
        try {
            stream = TextureLoader.openResourceStream(location);
            if (stream == null) {
                return false;
            }
            imageStream = new MemoryCacheImageInputStream(stream);
            var4_5 = null;
            try {
                for (ImageReader reader : ImmutableList.copyOf(ImageIO.getImageReaders(imageStream))) {
                    try {
                        reader.setInput(imageStream);
                        animated = reader.getNumImages(true) > 1;
                        reader.dispose();
                        stream.close();
                        var8_12 = animated;
                        return var8_12;
                    }
                    catch (IOException var7_10) {
                        ** try [egrp 4[TRYBLOCK] [7, 9 : 142->165)] { 
lbl19:
                        // 1 sources

                    }
                    finally {
                        reader.dispose();
                        continue;
                    }
                    {
                        catch (Throwable var5_8) {
                            var4_5 = var5_8;
                            throw var5_8;
                        }
lbl27:
                        // 1 sources

                        finally {
                        }
                    }
                }
            }
            finally {
                if (imageStream != null) {
                    if (var4_5 != null) {
                        try {
                            imageStream.close();
                        }
                        catch (Throwable var9_13) {
                            var4_5.addSuppressed(var9_13);
                        }
                    } else {
                        imageStream.close();
                    }
                }
            }
            stream.close();
        }
        catch (IOException var2_3) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureAnimator(BakedConfig images) {
        Minecraft mc = Minecraft.func_71410_x();
        for (BakedRenderingPart render : images.renderingParts) {
            String resource = render.render.getLocation();
            if (resource == null) continue;
            try {
                InputStream stream = TextureLoader.openResourceStream(new ResourceLocation(resource));
                if (stream == null) continue;
                BufferedImage[] frames = null;
                try (MemoryCacheImageInputStream imageStream = new MemoryCacheImageInputStream(stream);){
                    for (ImageReader reader : ImmutableList.copyOf(ImageIO.getImageReaders(imageStream))) {
                        try {
                            reader.setInput(imageStream);
                            int size = 0;
                            frames = new BufferedImage[reader.getNumImages(true)];
                            if (frames.length < 2) continue;
                            int read = 0;
                            for (int i = 0; i < frames.length; ++i) {
                                try {
                                    frames[read] = reader.read(i);
                                }
                                catch (IndexOutOfBoundsException e) {
                                    continue;
                                }
                                size += frames[read].getHeight() * frames[read].getWidth();
                                ++read;
                            }
                            if (read < frames.length) {
                                frames = Arrays.copyOf(frames, read);
                            }
                            if (frames.length < 2) {
                                stream.close();
                                continue;
                            }
                            CLSLog.info("Number of Frames = " + read);
                            this.animatedTextures.put(resource, new AnimatedTexture(frames, size));
                            reader.dispose();
                            break;
                        }
                        catch (IOException iOException) {}
                        continue;
                        finally {
                            reader.dispose();
                        }
                    }
                }
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void tick() {
        this.now = System.currentTimeMillis();
        for (AnimatedTexture tex : this.animatedTextures.values()) {
            tex.tick();
        }
    }

    public void close() {
        for (AnimatedTexture tex : this.animatedTextures.values()) {
            tex.delete();
        }
    }

    public void bindTexture(String resource, int frame, boolean loop) {
        if (this.animatedTextures.containsKey(resource)) {
            this.animatedTextures.get(resource).bindFrame(frame, loop);
        }
    }

    public static void uploadTextureImage(int textureId, BufferedImage texture) {
        TextureUtil.func_110991_a((int)textureId, (int)texture.getWidth(), (int)texture.getHeight());
        int width = texture.getWidth();
        int height = texture.getHeight();
        int count = 0x400000 / width;
        int[] data = new int[count * width];
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        for (int i = 0; i < width * height; i += width * count) {
            int iteration = i / width;
            int thisHeight = Math.min(count, height - iteration);
            int size = width * thisHeight;
            texture.getRGB(0, iteration, width, thisHeight, data, 0, width);
            DATA_BUFFER.clear();
            DATA_BUFFER.put(data, 0, size);
            DATA_BUFFER.position(0).limit(size);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)iteration, (int)width, (int)thisHeight, (int)32993, (int)33639, (IntBuffer)DATA_BUFFER);
        }
    }

    public class AnimatedTexture {
        private final int[] ids;
        private final long[] lastUsed;
        private final BufferedImage[] images;
        private final int textureMilliSeconds;

        public AnimatedTexture(BufferedImage[] images, int totalPixels) {
            this.images = images;
            this.ids = new int[images.length];
            this.lastUsed = new long[images.length];
            Arrays.fill(this.ids, -1);
            if (totalPixels <= 204800) {
                this.textureMilliSeconds = Integer.MAX_VALUE;
                for (int i = 0; i < images.length; ++i) {
                    this.bindFrame(i, false);
                }
            } else if (totalPixels <= 39321600) {
                this.textureMilliSeconds = 16384;
            } else {
                int higherPower = MathHelper.func_151239_c((int)(totalPixels / 39321600));
                this.textureMilliSeconds = 16384 >> higherPower;
            }
        }

        public void uploadFramesAhead(int frame, int number) {
            for (int f = frame + 1; f < frame + number; ++f) {
                int wf;
                int n = wf = f >= this.images.length ? f - this.images.length : f;
                if (wf >= this.images.length) break;
                if (this.ids[wf] != -1) continue;
                this.ids[wf] = GL11.glGenTextures();
                TextureAnimator.uploadTextureImage(this.ids[wf], this.images[wf]);
            }
        }

        public void bindFrame(int frame, boolean loop) {
            if (loop) {
                frame %= this.ids.length;
            } else if (frame < 0) {
                frame = 0;
            } else if (frame >= this.ids.length) {
                frame = this.ids.length - 1;
            }
            if (this.ids[frame] != -1) {
                GL11.glBindTexture((int)3553, (int)this.ids[frame]);
            } else {
                this.ids[frame] = GL11.glGenTextures();
                TextureAnimator.uploadTextureImage(this.ids[frame], this.images[frame]);
                GL11.glBindTexture((int)3553, (int)this.ids[frame]);
            }
            this.lastUsed[frame] = TextureAnimator.this.now;
            this.uploadFramesAhead(frame, 10);
        }

        public void delete() {
            for (int i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] == -1) continue;
                this.deleteFrame(i);
            }
        }

        private void deleteFrame(int frame) {
            TextureUtil.func_147942_a((int)this.ids[frame]);
            this.ids[frame] = -1;
        }

        private void tick() {
            for (int i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] == -1 || this.lastUsed[i] + (long)this.textureMilliSeconds >= TextureAnimator.this.now) continue;
                this.deleteFrame(i);
            }
        }
    }
}

