/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.repackage.buildcraft.lib.expression.info;

import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IDependancyVisitor;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IDependantNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;

public abstract class DependencyVisitorRouting
implements IDependancyVisitor {
    private boolean openForVisiting = true;

    protected void reopen() {
        this.openForVisiting = true;
    }

    protected void close() {
        this.openForVisiting = false;
    }

    public boolean isOpenForVisiting() {
        return this.openForVisiting;
    }

    protected abstract boolean visit(IExpressionNode var1);

    private boolean visitPotentialDependantNode(IExpressionNode node) {
        if (node instanceof IDependantNode) {
            this.dependOn((IDependantNode)((Object)node));
            return this.isOpenForVisiting();
        }
        return this.visit(node);
    }

    @Override
    public void dependOnExplictly(IExpressionNode node) {
        this.visit(node);
    }

    @Override
    public void dependOn(IExpressionNode node) {
        if (!this.isOpenForVisiting()) {
            return;
        }
        this.visitPotentialDependantNode(node);
    }

    @Override
    public void dependOn(IExpressionNode ... nodes) {
        if (this.isOpenForVisiting()) {
            for (IExpressionNode node : nodes) {
                if (this.visitPotentialDependantNode(node)) continue;
                this.close();
                return;
            }
        }
    }

    @Override
    public void dependOnNodes(Iterable<? extends IExpressionNode> nodes) {
        if (this.isOpenForVisiting()) {
            for (IExpressionNode iExpressionNode : nodes) {
                if (this.visitPotentialDependantNode(iExpressionNode)) continue;
                this.close();
                return;
            }
        }
    }

    private boolean visit(IDependantNode child) {
        child.visitDependants(this);
        return this.isOpenForVisiting();
    }

    @Override
    public void dependOn(IDependantNode child) {
        this.visit(child);
    }

    @Override
    public void dependOn(IDependantNode ... children) {
        if (this.isOpenForVisiting()) {
            for (IDependantNode child : children) {
                if (this.visit(child)) continue;
                return;
            }
        }
    }

    @Override
    public void dependOnChildren(Iterable<? extends IDependantNode> children) {
        if (this.isOpenForVisiting()) {
            for (IDependantNode iDependantNode : children) {
                if (this.visit(iDependantNode)) continue;
                return;
            }
        }
    }
}

