/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.cc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import gcewing.sg.features.cc.CCInterfaceTE;
import gcewing.sg.features.cc.CCMethod;
import gcewing.sg.features.cc.CCMethodQueue;
import gcewing.sg.features.cc.SGMethod;
import gcewing.sg.tileentity.SGInterfaceTE;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CCSGPeripheral
implements IPeripheral {
    static CCMethod[] methods = new CCMethod[]{new SGMethod("stargateState"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            SGInterfaceTE.CIStargateState result = te.ciStargateState();
            return new Object[]{result.state, result.chevrons, result.direction};
        }
    }, new SGMethod("energyAvailable"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            return new Object[]{te.ciEnergyAvailable()};
        }
    }, new SGMethod("energyToDial", 1){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            return new Object[]{te.ciEnergyToDial((String)args[0], false)};
        }
    }, new SGMethod("localAddress"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            return new Object[]{te.ciLocalAddress()};
        }
    }, new SGMethod("remoteAddress"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            return new Object[]{te.ciRemoteAddress()};
        }
    }, new SGMethod("dial", 1){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            te.ciDial((String)args[0], false);
            return null;
        }
    }, new SGMethod("disconnect"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            te.ciDisconnect();
            return null;
        }
    }, new SGMethod("irisState"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            return new Object[]{te.ciIrisState()};
        }
    }, new SGMethod("openIris"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            te.ciOpenIris();
            return null;
        }
    }, new SGMethod("closeIris"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            te.ciCloseIris();
            return null;
        }
    }, new SGMethod("sendMessage", -1){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            te.ciSendMessage(args);
            return null;
        }
    }};
    World world;
    BlockPos pos;

    public CCSGPeripheral(TileEntity te) {
        this.world = te.func_145831_w();
        this.pos = te.func_174877_v();
    }

    CCInterfaceTE getInterfaceTE() {
        TileEntity te = this.world.func_175625_s(this.pos);
        if (te instanceof CCInterfaceTE) {
            return (CCInterfaceTE)te;
        }
        return null;
    }

    public String getType() {
        return "stargate";
    }

    public String[] getMethodNames() {
        String[] result = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = CCSGPeripheral.methods[i].name;
        }
        return result;
    }

    public Object[] callMethod(IComputerAccess cpu, ILuaContext ctx, int method, Object[] args) throws LuaException, InterruptedException {
        if (method >= 0 && method < methods.length) {
            return CCMethodQueue.instance.invoke(cpu, ctx, this, methods[method], args);
        }
        throw new LuaException(String.format("Invalid method index %s", method));
    }

    public void attach(IComputerAccess cpu) {
        this.world.func_73046_m().func_152344_a(() -> {
            CCInterfaceTE te = this.getInterfaceTE();
            if (te != null) {
                te.attachedComputers.add(cpu);
            }
        });
    }

    public void detach(IComputerAccess cpu) {
        this.world.func_73046_m().func_152344_a(() -> {
            CCInterfaceTE te = this.getInterfaceTE();
            if (te != null) {
                te.attachedComputers.remove(cpu);
            }
        });
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }
}

