/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea.item;

import elucent.simplytea.SimplyTea;
import elucent.simplytea.core.Config;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TeapotFluidHandler
implements ICapabilityProvider,
IFluidHandlerItem {
    private ItemStack stack;

    public TeapotFluidHandler(ItemStack stack) {
        this.stack = stack;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        FluidStack fluid = null;
        int meta = this.stack.func_77960_j();
        if (meta > 0) {
            Fluid registered;
            String[] fluidNames;
            String[] stringArray = fluidNames = meta == 2 ? Config.teapot.milks : Config.teapot.waters;
            if (fluidNames.length != 0 && (registered = FluidRegistry.getFluid((String)fluidNames[0])) != null) {
                fluid = new FluidStack(registered, 1000);
            }
        }
        return new IFluidTankProperties[]{new FluidTankProperties(fluid, 1000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.stack.func_77952_i() != 0 || resource == null || resource.getFluid() == null || resource.amount < 1000) {
            return 0;
        }
        String fluid = resource.getFluid().getName();
        int meta = 2;
        if (Config.teapot.waterSet.contains(fluid)) {
            meta = 1;
        } else if (!Config.teapot.milkSet.contains(fluid)) {
            return 0;
        }
        if (doFill) {
            this.stack = new ItemStack(SimplyTea.teapot, 1, meta);
        }
        return 1000;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public ItemStack getContainer() {
        return this.stack;
    }
}

