/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.armor;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.item.armor.electric.ItemArmorElectricJetpack;
import ic2.core.item.armor.electric.ItemArmorQuantumSuit;
import ic2.core.item.inv.inventories.NuclearJetpackInventory;
import ic2.core.item.inv.logics.NuclearJetpackLogic;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.gravisuit.items.armor.ItemArmorGravisuit;
import trinsdar.gravisuit.util.GravisuitConfig;
import trinsdar.gravisuit.util.GravisuitLang;
import trinsdar.gravisuit.util.Registry;
import trinsdar.ic2c_extras.util.INuclearJetpackLogic;

@Optional.Interface(iface="trinsdar.ic2c_extras.util.INuclearJetpackLogic", modid="ic2c_extras")
public class ItemArmorNuclearGravisuit
extends ItemArmorQuantumSuit
implements ItemArmorJetpackBase.IIndirectJetpack,
IHandHeldInventory,
INuclearJetpackLogic {
    GravisuitJetpack jetpack = new GravisuitJetpack((Item)this);

    public ItemArmorNuclearGravisuit() {
        super(44, EntityEquipmentSlot.CHEST);
        this.setRegistryName("nucleargravisuit");
        this.setUnlocalizedName(GravisuitLang.nuclearGravisuit);
        this.maxCharge = GravisuitConfig.powerValues.nuclearGravisuitStorage;
        this.transferLimit = GravisuitConfig.powerValues.nuclearGravisuitTransfer;
        this.func_77637_a(IC2.tabIC2);
        this.tier = GravisuitConfig.enableGravisuitTier4 ? 4 : 3;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setMaxCharge(int storage) {
        this.maxCharge = storage;
    }

    public void setMaxTransfer(int maxTransfer) {
        this.transferLimit = maxTransfer;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int i) {
        return Ic2Icons.getTextures((String)"gravisuit_items")[22];
    }

    public String getTexture() {
        return "gravisuit:textures/models/nuclear_gravisuit";
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            if (IC2.platform.isSimulating()) {
                IC2.platform.launchGui(playerIn, this.getInventory(playerIn, hand, playerIn.func_184586_b(hand)), hand);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        this.jetpack.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        this.jetpack.onArmorTick(world, player, stack);
        this.jetpack.onReactorTick(world, player, stack);
    }

    public static boolean hasGravisuit(EntityPlayer player) {
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return !chest.func_190926_b() && chest.func_77973_b() instanceof ItemArmorGravisuit;
    }

    public static boolean hasQuantumLegs(EntityPlayer player) {
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        return !legs.func_190926_b() && legs.func_77973_b() instanceof ItemArmorQuantumSuit;
    }

    public ItemArmorJetpackBase getJetpack() {
        return this.jetpack;
    }

    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new NuclearJetpackInventory(player, (IHandHeldInventory)this, stack);
    }

    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        return nbt.func_74764_b("GuiID") ? nbt.func_74762_e("GuiID") : -1;
    }

    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData((ItemStack)stack).func_82580_o("GuiID");
        } else {
            StackUtil.getOrCreateNbtData((ItemStack)stack).func_74768_a("GuiID", id);
        }
    }

    @Optional.Method(modid="ic2c_extras")
    public NuclearJetpackLogic getLogic(EntityPlayer entityPlayer, ItemStack itemStack) {
        return this.jetpack.getLogic(entityPlayer, itemStack);
    }

    public static class GravisuitJetpack
    extends ItemArmorElectricJetpack {
        Item item;
        public static List<String> playersWithSet = new ArrayList<String>();

        public GravisuitJetpack(Item owner) {
            this.item = owner;
        }

        @SideOnly(value=Side.CLIENT)
        public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
            List<String> ctrlTip = sortedTooltip.get(ToolTipType.Ctrl);
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{GravisuitLang.gravisuitToggleCombo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(5), IC2.keyboard.getKeyName(1)}), GravisuitLang.graviEngineToggle}));
            ctrlTip.add(TextFormatting.UNDERLINE + GravisuitLang.graviEngineOnInfo.getLocalized());
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{GravisuitLang.doubleJump.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(6)}), GravisuitLang.creativeFly}));
            ctrlTip.add(TextFormatting.UNDERLINE + GravisuitLang.graviEngineOffInfo.getLocalized());
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(6), Ic2InfoLang.jetpackJumpToFly}));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(2), Ic2InfoLang.jetpackModeSwitch}));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(0), Ic2InfoLang.jetpackQuickToggle}));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(5), Ic2InfoLang.jetpackToggle}));
        }

        public boolean isElectricJetpack(ItemStack itemStack) {
            return true;
        }

        public boolean canDoAdvHoverMode(ItemStack stack) {
            return true;
        }

        public int getMaxHeight(ItemStack itemStack, int worldheight) {
            return (int)((float)worldheight * 1.171875f);
        }

        public String getTexture() {
            return "";
        }

        public int getTier(ItemStack itemStack) {
            return 3;
        }

        public double getTransferLimit(ItemStack itemStack) {
            return 0.0;
        }

        public int getJetpackUse(ItemStack stack) {
            NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
            return nbt.func_74767_n("enabled") ? 2 : nbt.func_74762_e("LastUseMode");
        }

        public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            boolean enabled = nbt.func_74767_n("enabled");
            PlayerHandler handler = PlayerHandler.getHandlerForPlayer((EntityPlayer)player);
            byte jetpackTicker = nbt.func_74771_c("JetpackTicker");
            boolean server = IC2.platform.isSimulating();
            if (enabled) {
                if (server) {
                    if (jetpackTicker > 0) {
                        jetpackTicker = (byte)(jetpackTicker - 1);
                        nbt.func_74774_a("JetpackTicker", jetpackTicker);
                    } else if (handler.toggleKeyDown && handler.boostKeyDown) {
                        nbt.func_74774_a("JetpackTicker", (byte)10);
                        nbt.func_74757_a("enabled", false);
                        IC2.platform.messagePlayer(player, GravisuitLang.graviEngineOff);
                    }
                }
            } else if (handler.toggleKeyDown && handler.boostKeyDown && jetpackTicker <= 0) {
                if (server) {
                    nbt.func_74757_a("enabled", true);
                    nbt.func_74774_a("JetpackTicker", (byte)10);
                    IC2.platform.messagePlayer(player, GravisuitLang.graviEngineOn);
                    return;
                }
            } else if (jetpackTicker > 0) {
                jetpackTicker = (byte)(jetpackTicker - 1);
                nbt.func_74774_a("JetpackTicker", jetpackTicker);
            }
            if (enabled) {
                if (ElectricItem.manager.getCharge(stack) >= 1024.0) {
                    if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                        if (handler.quantumArmorBoostSprint && player.func_70051_ag() && ItemArmorGravisuit.hasQuantumLegs(player)) {
                            this.useEnergy(player, stack, 1024);
                        } else {
                            this.useEnergy(player, stack, 512);
                        }
                    }
                    player.field_71075_bZ.field_75101_c = true;
                    player.field_70138_W = 1.0625f;
                    boolean flying = player.field_71075_bZ.field_75100_b;
                    if (flying) {
                        boolean sneaking = player.func_70093_af();
                        float speed = 0.08f * (flying ? 0.6f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                        if (player.field_191988_bg > 0.0f) {
                            player.func_191958_b(0.0f, 0.0f, 1.0f, speed);
                        } else if (player.field_191988_bg < 0.0f) {
                            player.func_191958_b(0.0f, 0.0f, 1.0f, -speed * 0.3f);
                        }
                        if (player.field_70702_br != 0.0f) {
                            player.func_191958_b(1.0f, 0.0f, 0.0f, speed * 0.5f * Math.signum(player.field_70702_br));
                        }
                    }
                } else if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                    player.field_70138_W = 0.6f;
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                }
            } else {
                if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                    player.field_70138_W = 0.6f;
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                }
                super.onArmorTick(world, player, stack);
            }
        }

        public void onReactorTick(World world, EntityPlayer player, ItemStack stack) {
            NuclearJetpackLogic logic = this.getLogic(player, stack);
            logic.onTick(stack);
            logic.save(stack);
        }

        public NuclearJetpackLogic getLogic(EntityPlayer player, ItemStack stack) {
            return new NuclearJetpackLogic(stack, player, this.field_77881_a);
        }

        public static String playerKey(EntityPlayer player) {
            return player.func_146103_bH().getName() + ":" + player.func_130014_f_().field_72995_K;
        }

        @SubscribeEvent
        public void updatePlayerAbilityStatus(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                String key = GravisuitJetpack.playerKey(player);
                ItemStack stack = new ItemStack((Item)Registry.gravisuit);
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
                boolean disabled = nbt.func_74767_n("disabled");
                Boolean hasSet = ItemArmorGravisuit.hasGravisuit(player);
                if (playersWithSet.contains(key)) {
                    if (!hasSet.booleanValue()) {
                        player.field_70138_W = 0.6f;
                        if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                            player.field_71075_bZ.field_75101_c = false;
                            player.field_71075_bZ.field_75100_b = false;
                        }
                        playersWithSet.remove(key);
                    }
                } else if (hasSet.booleanValue()) {
                    playersWithSet.add(key);
                }
            }
        }
    }
}

