/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render;

import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.ILayeredBlockBakery;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.light.BlockLight;
import cofh.thermalexpansion.block.light.TileLightBase;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BakeryLight
implements ILayeredBlockBakery {
    public static final BakeryLight INSTANCE = new BakeryLight();
    static CCModel modelCenter = CCModel.quadModel((int)24);
    static CCModel modelFrame = CCModel.quadModel((int)24);
    static CCModel modelHalo = CCModel.quadModel((int)24);

    public void renderCenter(CCRenderState ccrs, int color, TextureAtlasSprite texture) {
        if (texture != null) {
            modelCenter.setColour(color);
            modelCenter.render(ccrs, new IVertexOperation[]{new IconTransformation(texture)});
            modelCenter.setColour(-1);
        }
    }

    public void renderFrame(CCRenderState ccrs, int color, TextureAtlasSprite texture) {
        if (texture != null) {
            modelFrame.setColour(color);
            modelFrame.render(ccrs, new IVertexOperation[]{new IconTransformation(texture)});
            modelFrame.setColour(-1);
        }
    }

    public void renderHalo(CCRenderState ccrs, int color, TextureAtlasSprite texture) {
        if (texture != null) {
            modelHalo.setColour(color & 0xFFFFFF7F);
            modelHalo.render(ccrs, new IVertexOperation[]{new IconTransformation(texture)});
            modelHalo.setColour(-1);
        }
    }

    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.of((String)"Null tile. Position: %s", (Object[])new Object[]{pos}));
        }
        if (!(tile instanceof TileLightBase)) {
            return state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.of((String)"Tile is not an instance of TileLightBase, was %s. Pos: %s", (Object[])new Object[]{tile.getClass().getName(), pos}));
        }
        state = state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.OK);
        state = state.withProperty(TEProps.TILE_LIGHT, (Object)((TileLightBase)tile));
        return state;
    }

    public List<BakedQuad> bakeItemQuads(EnumFacing face, ItemStack stack) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (face != null && !stack.func_190926_b()) {
            int stackColor;
            int color = -1;
            boolean modified = false;
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Color") && (stackColor = stack.func_77978_p().func_74762_e("Color")) != -1) {
                color = (stackColor << 8) + 255;
                modified = true;
            }
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            CCRenderState ccrs = CCRenderState.instance();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            int metadata = ItemHelper.getItemDamage((ItemStack)stack);
            this.renderCenter(ccrs, color, this.getCenterTexture(metadata, modified));
            this.renderFrame(ccrs, color, this.getFrameTexture(metadata));
            buffer.func_178977_d();
            quads.addAll(buffer.bake());
        }
        return quads;
    }

    public List<BakedQuad> bakeLayerFace(EnumFacing face, BlockRenderLayer layer, IExtendedBlockState state) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (face != null && state != null) {
            TileLightBase light = (TileLightBase)((Object)state.getValue(TEProps.TILE_LIGHT));
            boolean modified = false;
            int color = -1;
            int type = ((BlockLight.Type)((Object)state.func_177229_b(BlockLight.VARIANT))).getMetadata();
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            if (layer == BlockRenderLayer.SOLID) {
                this.renderCenter(ccrs, color, this.getCenterTexture(type, modified));
            } else if (layer == BlockRenderLayer.CUTOUT) {
                this.renderFrame(ccrs, color, this.getFrameTexture(type));
            } else if (layer == BlockRenderLayer.TRANSLUCENT) {
                this.renderHalo(ccrs, color, this.getHaloTexture(type));
            }
            buffer.func_178977_d();
            quads.addAll(buffer.bake());
        }
        return quads;
    }

    private TextureAtlasSprite getCenterTexture(int metadata, boolean modified) {
        switch (metadata) {
            case 0: {
                return modified ? TETextures.ILLUMINATOR_CENTER_1 : TETextures.ILLUMINATOR_CENTER_0;
            }
            case 1: 
            case 2: {
                return null;
            }
        }
        return null;
    }

    private TextureAtlasSprite getFrameTexture(int metadata) {
        switch (metadata) {
            case 0: {
                return TETextures.ILLUMINATOR_FRAME;
            }
            case 1: 
            case 2: {
                return TETextures.LAMP_CENTER;
            }
        }
        return null;
    }

    private TextureAtlasSprite getHaloTexture(int metadata) {
        switch (metadata) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return TETextures.LAMP_HALO;
            }
        }
        return null;
    }

    static {
        modelCenter.generateBlock(0, Cuboid6.full.expand(-0.001953125));
        modelCenter.computeNormals();
        modelCenter.shrinkUVs(0.001953125);
        modelFrame.generateBlock(0, Cuboid6.full);
        modelFrame.computeNormals();
        modelFrame.shrinkUVs(0.001953125);
        modelHalo.generateBlock(0, Cuboid6.full.expand(0.125));
        modelHalo.computeNormals();
        modelHalo.shrinkUVs(0.001953125);
    }
}

