/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.tileentity;

import net.malisis.blocks.network.SwapperMessage;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.ItemUtils;
import net.malisis.core.util.MBlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.apache.commons.lang3.tuple.Pair;

public class SwapperTileEntity
extends TileEntity {
    private IBlockState[][][] states = new IBlockState[3][3][3];
    private NBTTagCompound[][][] tileEntities = new NBTTagCompound[3][3][3];

    public void swap() {
        AxisAlignedBB aabb = this.getAABB();
        for (BlockPos p : BlockPosUtils.getAllInBox((AxisAlignedBB)aabb)) {
            int x = (int)((double)p.func_177958_n() - aabb.field_72340_a);
            int y = (int)((double)p.func_177956_o() - aabb.field_72338_b);
            int z = (int)((double)p.func_177952_p() - aabb.field_72339_c);
            Pair<IBlockState, NBTTagCompound> worldState = this.getWorldState(p);
            Pair<IBlockState, NBTTagCompound> storedState = this.getStoredState(x, y, z);
            this.storeState(x, y, z, worldState);
            this.applyState(p, storedState);
            IBlockState stored = (IBlockState)storedState.getLeft();
            if (stored == null) {
                stored = Blocks.field_150350_a.func_176223_P();
            }
            this.func_145831_w().markAndNotifyBlock(p, this.func_145831_w().func_175726_f(p), (IBlockState)worldState.getLeft(), stored, 3);
        }
    }

    private AxisAlignedBB getAABB() {
        EnumFacing direction = DirectionalComponent.getDirection((IBlockAccess)this.func_145831_w(), (BlockPos)this.func_174877_v());
        AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, -1, -1), this.func_174877_v().func_177982_a(2, 2, 2));
        aabb = aabb.func_72317_d((double)(direction.func_82601_c() * 2), (double)(direction.func_96559_d() * 2), (double)(direction.func_82599_e() * 2));
        return aabb;
    }

    private Pair<IBlockState, NBTTagCompound> getWorldState(BlockPos pos) {
        IBlockState worldState = this.func_145831_w().func_180495_p(pos);
        if (worldState.func_177230_c() == Blocks.field_150357_h) {
            return Pair.of(null, null);
        }
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        if (te == null) {
            return Pair.of((Object)worldState, null);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        te.func_189515_b(nbt);
        return Pair.of((Object)worldState, (Object)nbt);
    }

    private Pair<IBlockState, NBTTagCompound> getStoredState(int x, int y, int z) {
        return Pair.of((Object)this.states[x][y][z], (Object)this.tileEntities[x][y][z]);
    }

    private void applyState(BlockPos pos, Pair<IBlockState, NBTTagCompound> state) {
        if (this.func_145831_w().func_180495_p(pos).func_177230_c() == Blocks.field_150357_h) {
            return;
        }
        this.clearWorldState(pos);
        this.func_145831_w().func_180501_a(pos, state.getLeft() != null ? (IBlockState)state.getLeft() : Blocks.field_150350_a.func_176223_P(), 3);
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        if (te != null && state.getRight() != null) {
            te.func_145839_a((NBTTagCompound)state.getRight());
            SwapperMessage.sendTileEntityTag(te);
        }
    }

    private void storeState(int x, int y, int z, Pair<IBlockState, NBTTagCompound> state) {
        this.states[x][y][z] = (IBlockState)state.getLeft();
        this.tileEntities[x][y][z] = (NBTTagCompound)state.getRight();
    }

    private void clearWorldState(BlockPos pos) {
        ExtendedBlockStorage ebs = this.func_145831_w().func_175726_f(pos).func_76587_i()[pos.func_177956_o() >> 4];
        ebs.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, Blocks.field_150350_a.func_176223_P());
        this.func_145831_w().func_175713_t(pos);
    }

    public void dropStoredStates() {
        for (int x = 0; x <= 2; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = 0; z <= 2; ++z) {
                    EntityUtils.spawnEjectedItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)ItemUtils.getItemStackFromState((IBlockState)this.states[x][y][z]));
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int x = 0; x <= 2; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = 0; z <= 2; ++z) {
                    int index = x + y * 3 + z * 9;
                    this.states[x][y][z] = MBlockState.fromNBT((NBTTagCompound)tag, (String)("block_" + index), (String)("metadata_" + index));
                    if (!tag.func_74764_b("tileEntity_" + index)) continue;
                    this.tileEntities[x][y][z] = tag.func_74775_l("tileEntity_" + index);
                }
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        for (int x = 0; x <= 2; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = 0; z <= 2; ++z) {
                    int index = x + y * 3 + z * 9;
                    Pair<IBlockState, NBTTagCompound> storedState = this.getStoredState(x, y, z);
                    IBlockState state = (IBlockState)storedState.getLeft();
                    if (state == null || state.func_177230_c() == Blocks.field_150350_a) continue;
                    MBlockState.toNBT((NBTTagCompound)tag, (IBlockState)state, (String)("block_" + index), (String)("metadata_" + index));
                    if (storedState.getRight() == null) continue;
                    tag.func_74782_a("tileEntity_" + index, (NBTBase)storedState.getRight());
                }
            }
        }
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        AxisAlignedBB aabb = this.getAABB();
        this.func_145831_w().func_175704_b(new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new BlockPos(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

