/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcrestrict.Commands;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.moddedminecraft.mmcrestrict.Data.ItemData;
import net.moddedminecraft.mmcrestrict.Data.ModData;
import net.moddedminecraft.mmcrestrict.Main;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;

public class Edit
implements CommandExecutor {
    private final Main plugin;

    public Edit(Main plugin) {
        this.plugin = plugin;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Optional itemIDOP = args.getOne("ItemID");
        Optional optionOP = args.getOne("Option");
        Optional valueOP = args.getOne("True/False/Message");
        ArrayList<ItemData> items = new ArrayList<ItemData>(this.plugin.getItemData());
        ArrayList<ModData> mods = new ArrayList<ModData>(this.plugin.getModData());
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        ArrayList<Text> contents = new ArrayList<Text>();
        if (itemIDOP.isPresent()) {
            String itemType = (String)itemIDOP.get();
            if (optionOP.isPresent()) {
                if (!valueOP.isPresent()) {
                    throw new CommandException(this.plugin.fromLegacy("&cInvalid usage: /restrict edit ItemID [Option] [Value]"));
                }
                String option = (String)optionOP.get();
                String value = (String)valueOP.get();
                if (!mods.isEmpty()) {
                    for (ModData mod : mods) {
                        if (!mod.getMod().equals(itemType)) continue;
                        switch (option) {
                            case "name": {
                                mod.setItemname(value);
                                this.plugin.logToFile("ban-list", "World for " + mod.getModname() + " was changed to " + value);
                                src.sendMessage(this.plugin.fromLegacy("&2Name set to: &6" + value));
                                break;
                            }
                            case "reason": {
                                mod.setBanreason(value);
                                this.plugin.logToFile("ban-list", "Reason for " + mod.getModname() + " was changed to " + value);
                                src.sendMessage(this.plugin.fromLegacy("&2Reason set to: &6" + value));
                                break;
                            }
                            case "use": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    mod.setUsagebanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Usage for " + mod.getModname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Usage set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            case "own": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    mod.setOwnershipbanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Ownership for " + mod.getModname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Ownership set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            case "break": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    mod.setBreakingbanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Breaking for " + mod.getModname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Breaking set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            case "place": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    mod.setPlacingbanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Placing for " + mod.getModname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Placing set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            case "drop": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    mod.setDropbanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Drop for " + mod.getModname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Drop set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            case "craft": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    mod.setCraftbanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Craft for " + mod.getModname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Craft set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            default: {
                                throw new CommandException(this.plugin.fromLegacy("&cInvalid usage: /restrict edit ItemID [Option] [Value]"));
                            }
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            src.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                    }
                }
                if (!items.isEmpty()) {
                    for (ItemData item : items) {
                        if (!item.getItemid().equals(itemType)) continue;
                        switch (option) {
                            case "name": {
                                item.setItemname(value);
                                this.plugin.logToFile("ban-list", "World for " + item.getItemname() + " was changed to " + value);
                                src.sendMessage(this.plugin.fromLegacy("&2Name set to: &6" + value));
                                break;
                            }
                            case "reason": {
                                item.setBanreason(value);
                                this.plugin.logToFile("ban-list", "Reason for " + item.getItemname() + " was changed to " + value);
                                src.sendMessage(this.plugin.fromLegacy("&2Reason set to: &6" + value));
                                break;
                            }
                            case "use": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    item.setUsagebanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Usage for " + item.getItemname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Usage set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            case "own": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    item.setOwnershipbanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Ownership for " + item.getItemname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Ownership set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            case "break": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    item.setBreakingbanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Breaking for " + item.getItemname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Breaking set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            case "place": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    item.setPlacingbanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Placing for " + item.getItemname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Placing set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            case "world": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    item.setWorldbanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "World for " + item.getItemname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2World set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            case "drop": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    item.setDropbanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Drop for " + item.getItemname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Drop set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            case "craft": {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    item.setCraftbanned(Boolean.parseBoolean(value));
                                    this.plugin.logToFile("ban-list", "Craft for " + item.getItemname() + " was changed to " + value);
                                    src.sendMessage(this.plugin.fromLegacy("&2Craft set to: &6" + value));
                                    break;
                                }
                                src.sendMessage(this.plugin.fromLegacy("&cInvalid value: " + value + ". Must be true or false"));
                                break;
                            }
                            default: {
                                throw new CommandException(this.plugin.fromLegacy("&cInvalid usage: /restrict edit ItemID [Option] [Value]"));
                            }
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            src.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                    }
                }
                return CommandResult.success();
            }
            boolean valid = false;
            if (!mods.isEmpty()) {
                for (ModData mod : mods) {
                    if (!mod.getMod().equals(itemType)) continue;
                    valid = true;
                    if (src.hasPermission("mmcrestrict.commands.remove")) {
                        contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&3[&6Remove&3]")}).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("Click here to remove this item from the ban list"))).onClick((ClickAction)TextActions.runCommand((String)("/restrict remove " + mod.getMod()))).build());
                    }
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6ID: &7" + mod.getMod())}).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Name: &7" + mod.getModname())}).onClick((ClickAction)TextActions.suggestCommand((String)("/restrict edit " + mod.getMod() + " name " + mod.getModname()))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Name"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Ban Reason: &7" + mod.getBanreason())}).onClick((ClickAction)TextActions.suggestCommand((String)("/restrict edit " + mod.getMod() + " reason [MESSAGE]"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Reason"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Usage Banned: &7" + mod.getUsagebanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValueMod(mod.getMod(), "use"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Usage"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Breaking Banned: &7" + mod.getBreakingbanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValueMod(mod.getMod(), "break"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Breaking"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Placing Banned: &7" + mod.getPlacingbanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValueMod(mod.getMod(), "place"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Placing"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Ownership Banned: &7" + mod.getOwnershipbanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValueMod(mod.getMod(), "own"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Ownership"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Drop Banned: &7" + mod.getDropbanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValueMod(mod.getMod(), "drop"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Drop"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Craft Banned: &7" + mod.getCraftbanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValueMod(mod.getMod(), "craft"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Craft"))).build());
                }
            }
            if (!items.isEmpty()) {
                for (ItemData item : items) {
                    if (!item.getItemid().equals(itemType)) continue;
                    valid = true;
                    if (src.hasPermission("mmcrestrict.commands.remove")) {
                        contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&3[&6Remove&3]")}).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("Click here to remove this item from the ban list"))).onClick((ClickAction)TextActions.runCommand((String)("/restrict remove " + item.getItemid()))).build());
                    }
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6ID: &7" + item.getItemid())}).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Name: &7" + item.getItemname())}).onClick((ClickAction)TextActions.suggestCommand((String)("/restrict edit " + item.getItemid() + " name " + item.getItemname()))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Name"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Ban Reason: &7" + item.getBanreason())}).onClick((ClickAction)TextActions.suggestCommand((String)("/restrict edit " + item.getItemid() + " reason [MESSAGE]"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Reason"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Usage Banned: &7" + item.getUsagebanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValue(item.getItemid(), "use"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Usage"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Breaking Banned: &7" + item.getBreakingbanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValue(item.getItemid(), "break"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Breaking"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Placing Banned: &7" + item.getPlacingbanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValue(item.getItemid(), "place"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Placing"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Ownership Banned: &7" + item.getOwnershipbanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValue(item.getItemid(), "own"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Ownership"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Drop Banned: &7" + item.getDropbanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValue(item.getItemid(), "drop"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Drop"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6Craft Banned: &7" + item.getCraftbanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValue(item.getItemid(), "craft"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6Craft"))).build());
                    contents.add(Text.builder().append(new Text[]{this.plugin.fromLegacy("&6World Banned: &7" + item.getWorldbanned())}).onClick((ClickAction)TextActions.executeCallback(this.checkValue(item.getItemid(), "world"))).onHover((HoverAction)TextActions.showText((Text)this.plugin.fromLegacy("&3Click here to change the value of &6World"))).build());
                }
            }
            if (!valid) {
                throw new CommandException(this.plugin.fromLegacy("&cItem specified is not currently banned"));
            }
            paginationService.builder().title(this.plugin.fromLegacy("&6Edit")).contents(contents).padding((Text)Text.of((String)"-")).sendTo((MessageReceiver)src);
            return CommandResult.success();
        }
        throw new CommandException(this.plugin.fromLegacy("&cInvalid usage: /restrict edit ItemID [Option] [Value]"));
    }

    private Consumer<CommandSource> checkValue(String itemID, String itemValue) {
        return consumer -> {
            ArrayList<ItemData> items = new ArrayList<ItemData>(this.plugin.getItemData());
            block32: for (ItemData item : items) {
                if (!item.getItemid().equals(itemID)) continue;
                switch (itemValue) {
                    case "use": {
                        if (item.getUsagebanned().booleanValue()) {
                            item.setUsagebanned(false);
                            this.plugin.logToFile("ban-list", "Usage for " + item.getItemname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Usage set to &6false"));
                        } else {
                            item.setUsagebanned(true);
                            this.plugin.logToFile("ban-list", "Usage for " + item.getItemname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Usage set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block32;
                    }
                    case "break": {
                        if (item.getBreakingbanned().booleanValue()) {
                            item.setBreakingbanned(false);
                            this.plugin.logToFile("ban-list", "Breaking for " + item.getItemname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Breaking set to &6false"));
                        } else {
                            item.setBreakingbanned(true);
                            this.plugin.logToFile("ban-list", "Breaking for " + item.getItemname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Breaking set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block32;
                    }
                    case "place": {
                        if (item.getPlacingbanned().booleanValue()) {
                            item.setPlacingbanned(false);
                            this.plugin.logToFile("ban-list", "Placing for " + item.getItemname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Placing set to &6false"));
                        } else {
                            item.setPlacingbanned(true);
                            this.plugin.logToFile("ban-list", "Placing for " + item.getItemname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Placing set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block32;
                    }
                    case "own": {
                        if (item.getOwnershipbanned().booleanValue()) {
                            item.setOwnershipbanned(false);
                            this.plugin.logToFile("ban-list", "Ownership for " + item.getItemname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Ownership set to &6false"));
                        } else {
                            item.setOwnershipbanned(true);
                            this.plugin.logToFile("ban-list", "Ownership for " + item.getItemname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Ownership set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block32;
                    }
                    case "world": {
                        if (item.getWorldbanned().booleanValue()) {
                            item.setWorldbanned(false);
                            this.plugin.logToFile("ban-list", "World for " + item.getItemname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2World set to &6false"));
                        } else {
                            item.setWorldbanned(true);
                            this.plugin.logToFile("ban-list", "World for " + item.getItemname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2World set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block32;
                    }
                    case "drop": {
                        if (item.getDropbanned().booleanValue()) {
                            item.setDropbanned(false);
                            this.plugin.logToFile("ban-list", "Drop for " + item.getItemname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Drop set to &6false"));
                        } else {
                            item.setDropbanned(true);
                            this.plugin.logToFile("ban-list", "Drop for " + item.getItemname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Drop set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block32;
                    }
                    case "craft": {
                        if (item.getCraftbanned().booleanValue()) {
                            item.setCraftbanned(false);
                            this.plugin.logToFile("ban-list", "Craft for " + item.getItemname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Craft set to &6false"));
                        } else {
                            item.setCraftbanned(true);
                            this.plugin.logToFile("ban-list", "Craft for " + item.getItemname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Craft set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block32;
                    }
                }
                consumer.sendMessage(this.plugin.fromLegacy("Invalid usage"));
            }
        };
    }

    private Consumer<CommandSource> checkValueMod(String ID, String itemValue) {
        return consumer -> {
            ArrayList<ModData> mods = new ArrayList<ModData>(this.plugin.getModData());
            block28: for (ModData mod : mods) {
                if (!mod.getMod().equals(ID)) continue;
                switch (itemValue) {
                    case "use": {
                        if (mod.getUsagebanned().booleanValue()) {
                            mod.setUsagebanned(false);
                            this.plugin.logToFile("ban-list", "Usage for " + mod.getModname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Usage set to &6false"));
                        } else {
                            mod.setUsagebanned(true);
                            this.plugin.logToFile("ban-list", "Usage for " + mod.getModname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Usage set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block28;
                    }
                    case "break": {
                        if (mod.getBreakingbanned().booleanValue()) {
                            mod.setBreakingbanned(false);
                            this.plugin.logToFile("ban-list", "Breaking for " + mod.getModname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Breaking set to &6false"));
                        } else {
                            mod.setBreakingbanned(true);
                            this.plugin.logToFile("ban-list", "Breaking for " + mod.getModname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Breaking set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block28;
                    }
                    case "place": {
                        if (mod.getPlacingbanned().booleanValue()) {
                            mod.setPlacingbanned(false);
                            this.plugin.logToFile("ban-list", "Placing for " + mod.getModname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Placing set to &6false"));
                        } else {
                            mod.setPlacingbanned(true);
                            this.plugin.logToFile("ban-list", "Placing for " + mod.getModname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Placing set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block28;
                    }
                    case "own": {
                        if (mod.getOwnershipbanned().booleanValue()) {
                            mod.setOwnershipbanned(false);
                            this.plugin.logToFile("ban-list", "Ownership for " + mod.getModname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Ownership set to &6false"));
                        } else {
                            mod.setOwnershipbanned(true);
                            this.plugin.logToFile("ban-list", "Ownership for " + mod.getModname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Ownership set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block28;
                    }
                    case "drop": {
                        if (mod.getDropbanned().booleanValue()) {
                            mod.setDropbanned(false);
                            this.plugin.logToFile("ban-list", "Drop for " + mod.getModname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Drop set to &6false"));
                        } else {
                            mod.setDropbanned(true);
                            this.plugin.logToFile("ban-list", "Drop for " + mod.getModname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Drop set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block28;
                    }
                    case "craft": {
                        if (mod.getCraftbanned().booleanValue()) {
                            mod.setCraftbanned(false);
                            this.plugin.logToFile("ban-list", "Craft for " + mod.getModname() + " was changed to false");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Craft set to &6false"));
                        } else {
                            mod.setCraftbanned(true);
                            this.plugin.logToFile("ban-list", "Craft for " + mod.getModname() + " was changed to true");
                            consumer.sendMessage(this.plugin.fromLegacy("&2Craft set to &6true"));
                        }
                        try {
                            this.plugin.saveData();
                        }
                        catch (Exception e) {
                            consumer.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                            e.printStackTrace();
                        }
                        continue block28;
                    }
                }
                consumer.sendMessage(this.plugin.fromLegacy("Invalid usage"));
            }
        };
    }
}

