/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.CheckBox;
import vswe.superfactory.components.CheckBoxList;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.ComponentMenuCamouflageAdvanced;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.TextBoxNumber;
import vswe.superfactory.components.TextBoxNumberList;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuCamouflageShape
extends ComponentMenuCamouflageAdvanced {
    private static final int CHECK_BOX_SPACING_X = 50;
    private static final int CHECK_BOX_SPACING_Y = 10;
    private static final int CHECK_BOX_X = 5;
    private static final int CHECK_BOX_Y = 3;
    private static final String NBT_COLLISION = "UseCollision";
    private static final String NBT_FULL = "FullCollision";
    private static final String NBT_MAX_X = "MaxX";
    private static final String NBT_MAX_Y = "MaxY";
    private static final String NBT_MAX_Z = "MaxZ";
    private static final String NBT_MIN_X = "MinX";
    private static final String NBT_MIN_Y = "MinY";
    private static final String NBT_MIN_Z = "MinZ";
    private static final String NBT_USE = "Use";
    private static final int TEXT_BOX_SPACING_X = 40;
    private static final int TEXT_BOX_SPACING_Y = 15;
    private static final int TEXT_BOX_X = 30;
    private static final int TEXT_BOX_Y = 25;
    private static final int TEXT_X = 6;
    private static final int TEXT_X_TO = 55;
    private static final int TEXT_Y = 28;
    private CheckBoxList checkBoxes;
    private Localization[] coordinates = new Localization[]{Localization.X, Localization.Y, Localization.Z};
    private boolean fullCollision;
    private boolean inUse;
    private TextBoxNumberList textBoxes;
    private boolean useCollision;

    public ComponentMenuCamouflageShape(FlowComponent parent) {
        super(parent);
        this.checkBoxes = new CheckBoxList();
        this.checkBoxes.addCheckBox(new CheckBox(Localization.CAMOUFLAGE_BOUNDS_USE, 5, 3){

            @Override
            public boolean getValue() {
                return ComponentMenuCamouflageShape.this.inUse;
            }

            @Override
            public void setValue(boolean val) {
                ComponentMenuCamouflageShape.this.inUse = val;
            }

            @Override
            public void onUpdate() {
                ComponentMenuCamouflageShape.this.sendCheckBoxPacket();
            }
        });
        this.checkBoxes.addCheckBox(new CheckBox(Localization.CAMOUFLAGE_COLLISION_USE, 5, 13){

            @Override
            public void setValue(boolean val) {
                ComponentMenuCamouflageShape.this.useCollision = val;
            }

            @Override
            public boolean getValue() {
                return ComponentMenuCamouflageShape.this.useCollision;
            }

            @Override
            public void onUpdate() {
                ComponentMenuCamouflageShape.this.sendCheckBoxPacket();
            }

            @Override
            public boolean isVisible() {
                return ComponentMenuCamouflageShape.this.inUse;
            }
        });
        this.checkBoxes.addCheckBox(new CheckBox(Localization.CAMOUFLAGE_COLLISION_FULL, 55, 13){

            @Override
            public void setValue(boolean val) {
                ComponentMenuCamouflageShape.this.fullCollision = val;
            }

            @Override
            public boolean getValue() {
                return ComponentMenuCamouflageShape.this.fullCollision;
            }

            @Override
            public void onUpdate() {
                ComponentMenuCamouflageShape.this.sendCheckBoxPacket();
            }

            @Override
            public boolean isVisible() {
                return ComponentMenuCamouflageShape.this.inUse && ComponentMenuCamouflageShape.this.useCollision;
            }
        });
        this.textBoxes = new TextBoxNumberList();
        for (int i = 0; i < 6; ++i) {
            int x = i % 2;
            int y = i / 2;
            this.textBoxes.addTextBox(new TextBoxRange(i, 30 + 40 * x, 25 + 15 * y, x == 0 ? 0 : 32));
        }
        this.loadDefault();
    }

    private void sendCheckBoxPacket() {
        DataWriter dw = this.getWriterForServerComponentPacket();
        dw.writeData(0, DataBitHelper.CAMOUFLAGE_BOUND_TYPE);
        dw.writeBoolean(this.inUse);
        if (this.inUse) {
            dw.writeBoolean(this.useCollision);
            dw.writeBoolean(this.fullCollision);
        }
        PacketHandler.sendDataToServer(dw);
    }

    private void loadDefault() {
        this.inUse = false;
        this.useCollision = true;
        this.fullCollision = false;
        for (int i = 0; i < 6; ++i) {
            ((TextBoxRange)this.textBoxes.getTextBox(i)).reset();
        }
    }

    public boolean shouldUpdate() {
        return this.inUse;
    }

    public boolean isUseCollision() {
        return this.useCollision;
    }

    public boolean isFullCollision() {
        return this.fullCollision;
    }

    public int getBounds(int id) {
        return this.textBoxes.getTextBox(id).getNumber();
    }

    @Override
    public String getName() {
        return Localization.BOUNDS_MENU.toString();
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.checkBoxes.onClick(mX, mY);
        if (this.inUse) {
            this.textBoxes.onClick(mX, mY, button);
        }
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        if (this.inUse) {
            return this.textBoxes.onKeyStroke(gui, c, k);
        }
        return super.onKeyStroke(gui, c, k);
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeBoolean(this.inUse);
        if (this.inUse) {
            dw.writeBoolean(this.useCollision);
            dw.writeBoolean(this.fullCollision);
            for (int i = 0; i < 6; ++i) {
                dw.writeData(this.textBoxes.getTextBox(i).getNumber(), DataBitHelper.CAMOUFLAGE_BOUNDS);
            }
        }
    }

    @Override
    public void readData(DataReader dr) {
        this.inUse = dr.readBoolean();
        if (this.inUse) {
            this.useCollision = dr.readBoolean();
            this.fullCollision = dr.readBoolean();
            for (int i = 0; i < 6; ++i) {
                this.textBoxes.getTextBox(i).setNumber(dr.readData(DataBitHelper.CAMOUFLAGE_BOUNDS));
            }
        } else {
            this.loadDefault();
        }
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        ComponentMenuCamouflageShape menuShape = (ComponentMenuCamouflageShape)menu;
        if (menuShape.inUse) {
            this.inUse = true;
            this.useCollision = menuShape.useCollision;
            this.fullCollision = menuShape.fullCollision;
            for (int i = 0; i < 6; ++i) {
                this.textBoxes.getTextBox(i).setNumber(menuShape.textBoxes.getTextBox(i).getNumber());
            }
        } else {
            this.loadDefault();
        }
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuCamouflageShape newDataShape = (ComponentMenuCamouflageShape)newData;
        if (this.inUse != newDataShape.inUse || this.useCollision != newDataShape.useCollision || this.fullCollision != newDataShape.fullCollision) {
            this.inUse = newDataShape.inUse;
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            dw.writeData(0, DataBitHelper.CAMOUFLAGE_BOUND_TYPE);
            dw.writeBoolean(this.inUse);
            if (!this.inUse) {
                this.loadDefault();
            } else {
                this.useCollision = newDataShape.useCollision;
                this.fullCollision = newDataShape.fullCollision;
                dw.writeBoolean(this.useCollision);
                dw.writeBoolean(this.fullCollision);
            }
            PacketHandler.sendDataToListeningClients(container, dw);
        }
        for (int i = 0; i < 6; ++i) {
            if (this.textBoxes.getTextBox(i).getNumber() == newDataShape.textBoxes.getTextBox(i).getNumber()) continue;
            this.textBoxes.getTextBox(i).setNumber(newDataShape.textBoxes.getTextBox(i).getNumber());
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            dw.writeData(i + 1, DataBitHelper.CAMOUFLAGE_BOUND_TYPE);
            dw.writeData(this.textBoxes.getTextBox(i).getNumber(), DataBitHelper.CAMOUFLAGE_BOUNDS);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.inUse = nbtTagCompound.func_74767_n(NBT_USE);
        if (this.inUse) {
            this.useCollision = nbtTagCompound.func_74767_n(NBT_COLLISION);
            this.fullCollision = nbtTagCompound.func_74767_n(NBT_FULL);
            this.textBoxes.getTextBox(0).setNumber(nbtTagCompound.func_74771_c(NBT_MIN_X));
            this.textBoxes.getTextBox(1).setNumber(nbtTagCompound.func_74771_c(NBT_MAX_X));
            this.textBoxes.getTextBox(2).setNumber(nbtTagCompound.func_74771_c(NBT_MIN_Y));
            this.textBoxes.getTextBox(3).setNumber(nbtTagCompound.func_74771_c(NBT_MAX_Y));
            this.textBoxes.getTextBox(4).setNumber(nbtTagCompound.func_74771_c(NBT_MIN_Z));
            this.textBoxes.getTextBox(5).setNumber(nbtTagCompound.func_74771_c(NBT_MAX_Z));
        } else {
            this.loadDefault();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74757_a(NBT_USE, this.inUse);
        if (this.inUse) {
            nbtTagCompound.func_74757_a(NBT_COLLISION, this.useCollision);
            nbtTagCompound.func_74757_a(NBT_FULL, this.fullCollision);
            nbtTagCompound.func_74774_a(NBT_MIN_X, (byte)this.textBoxes.getTextBox(0).getNumber());
            nbtTagCompound.func_74774_a(NBT_MAX_X, (byte)this.textBoxes.getTextBox(1).getNumber());
            nbtTagCompound.func_74774_a(NBT_MIN_Y, (byte)this.textBoxes.getTextBox(2).getNumber());
            nbtTagCompound.func_74774_a(NBT_MAX_Y, (byte)this.textBoxes.getTextBox(3).getNumber());
            nbtTagCompound.func_74774_a(NBT_MIN_Z, (byte)this.textBoxes.getTextBox(4).getNumber());
            nbtTagCompound.func_74774_a(NBT_MAX_Z, (byte)this.textBoxes.getTextBox(5).getNumber());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        this.checkBoxes.draw(gui, mX, mY);
        if (this.inUse) {
            this.textBoxes.draw(gui, mX, mY);
            for (int i = 0; i < this.coordinates.length; ++i) {
                gui.drawString(this.coordinates[i].toString(), 6, 28 + 15 * i, 0x404040);
                gui.drawString(Localization.TO.toString(), 55, 28 + 15 * i, 0x404040);
            }
        }
    }

    @Override
    protected String getWarningText() {
        return Localization.BOUNDS_WARNING.toString();
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        int id = dr.readData(DataBitHelper.CAMOUFLAGE_BOUND_TYPE);
        if (id == 0) {
            this.inUse = dr.readBoolean();
            if (this.inUse) {
                this.useCollision = dr.readBoolean();
                this.fullCollision = dr.readBoolean();
            } else {
                this.loadDefault();
            }
        } else {
            this.textBoxes.getTextBox(id - 1).setNumber(dr.readData(DataBitHelper.CAMOUFLAGE_BOUNDS));
        }
    }

    private class TextBoxRange
    extends TextBoxNumber {
        private int defaultNumber;
        private int id;

        public TextBoxRange(int id, int x, int y, int defaultNumber) {
            super(x, y, 2, false);
            this.defaultNumber = defaultNumber;
            this.id = id;
        }

        @Override
        public int getMaxNumber() {
            return 32;
        }

        @Override
        public void onNumberChanged() {
            DataWriter dw = ComponentMenuCamouflageShape.this.getWriterForServerComponentPacket();
            dw.writeData(this.id + 1, DataBitHelper.CAMOUFLAGE_BOUND_TYPE);
            dw.writeData(this.getNumber(), DataBitHelper.CAMOUFLAGE_BOUNDS);
            PacketHandler.sendDataToServer(dw);
        }

        public void reset() {
            this.setNumber(this.defaultNumber);
        }
    }
}

