/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.tiles;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.blocks.BlockCable;
import vswe.superfactory.blocks.ConnectionBlock;
import vswe.superfactory.blocks.ConnectionBlockType;
import vswe.superfactory.blocks.ISystemListener;
import vswe.superfactory.blocks.ITileEntityInterface;
import vswe.superfactory.components.CommandExecutor;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.ComponentMenuContainer;
import vswe.superfactory.components.ComponentMenuCraftingPriority;
import vswe.superfactory.components.ComponentMenuGroup;
import vswe.superfactory.components.ComponentMenuInterval;
import vswe.superfactory.components.ComponentMenuStuff;
import vswe.superfactory.components.ComponentMenuTarget;
import vswe.superfactory.components.ComponentMenuVariable;
import vswe.superfactory.components.Connection;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.Point;
import vswe.superfactory.components.TriggerHelperBUD;
import vswe.superfactory.components.TriggerHelperRedstone;
import vswe.superfactory.components.Variable;
import vswe.superfactory.components.VariableColor;
import vswe.superfactory.components.internal.ComponentType;
import vswe.superfactory.components.internal.ConnectionOption;
import vswe.superfactory.components.internal.ConnectionSet;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.interfaces.IInterfaceRenderer;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.IComponentNetworkReader;
import vswe.superfactory.network.packets.PacketHandler;
import vswe.superfactory.settings.Settings;
import vswe.superfactory.tiles.TileEntityBUD;
import vswe.superfactory.tiles.TileEntityCluster;
import vswe.superfactory.tiles.TileEntityClusterElement;
import vswe.superfactory.tiles.TileEntityInput;
import vswe.superfactory.util.WorldCoordinate;

public class TileEntityManager
extends TileEntity
implements ITileEntityInterface,
ITickable {
    public static final int BUTTON_INNER_SIZE_H = 12;
    public static final int BUTTON_INNER_SIZE_W = 12;
    public static final int BUTTON_INNER_SRC_X = 230;
    public static final int BUTTON_INNER_SRC_Y = 0;
    public static final int BUTTON_SIZE_H = 14;
    public static final int BUTTON_SIZE_W = 14;
    public static final int BUTTON_SRC_X = 242;
    public static final int BUTTON_SRC_Y = 0;
    public static final int MAX_CABLE_LENGTH = 256;
    public static final int MAX_COMPONENT_AMOUNT = 511;
    public static final int MAX_CONNECTED_INVENTORIES = 2048;
    public static final TriggerHelperBUD budTrigger = new TriggerHelperBUD();
    public static final TriggerHelperRedstone redstoneCondition = new TriggerHelperRedstone(1, 2);
    public static final TriggerHelperRedstone redstoneTrigger = new TriggerHelperRedstone(3, 4);
    private static final String NBT_COMPONENTS = "Components";
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_VARIABLES = "Variables";
    private static final String NBT_INVENTORY_POSITIONS = "InventoryPositions";
    public List<Button> buttons;
    public boolean justSentServerComponentRemovalPacket;
    @SideOnly(value=Side.CLIENT)
    public IInterfaceRenderer specialRenderer;
    private List<BlockPos> initialInventoryPositions = new ArrayList<BlockPos>();
    List<ConnectionBlock> inventories = new ArrayList<ConnectionBlock>();
    private Connection currentlyConnecting;
    private boolean firstCommandExecution = true;
    private boolean firstInventoryUpdate = true;
    private List<FlowComponent> items;
    private List<Integer> removedIds;
    private FlowComponent selectedComponent;
    private TileEntityManager self = this;
    private int timer = 0;
    private boolean usingUnlimitedInventories;
    private Variable[] variables;
    private List<FlowComponent> zLevelRenderingList;

    public TileEntityManager() {
        int i;
        this.items = new ArrayList<FlowComponent>();
        this.zLevelRenderingList = new ArrayList<FlowComponent>();
        this.buttons = new ArrayList<Button>();
        this.removedIds = new ArrayList<Integer>();
        this.variables = new Variable[VariableColor.values().length];
        for (i = 0; i < this.variables.length; ++i) {
            this.variables[i] = new Variable(i);
        }
        for (i = 0; i < ComponentType.values().length; ++i) {
            this.buttons.add(new ButtonCreate(ComponentType.values()[i]));
        }
        this.buttons.add(new Button(Localization.DELETE_COMMAND){

            @Override
            protected void onClick(DataReader dr) {
                int idToRemove = dr.readComponentId();
                TileEntityManager.this.removeFlowComponent(idToRemove);
            }

            @Override
            public boolean onClick(DataWriter dw) {
                TileEntityManager.this.justSentServerComponentRemovalPacket = true;
                for (FlowComponent item : TileEntityManager.this.items) {
                    if (!item.isBeingMoved()) continue;
                    dw.writeComponentId(TileEntityManager.this.self, item.getId());
                    return true;
                }
                return false;
            }

            @Override
            public boolean activateOnRelease() {
                return true;
            }
        });
        this.buttons.add(new Button(Localization.PREFERENCES){

            @Override
            protected void onClick(DataReader dr) {
            }

            @Override
            public boolean onClick(DataWriter dw) {
                Settings.openMenu(TileEntityManager.this.self);
                return false;
            }
        });
        this.buttons.add(new Button(Localization.EXIT_GROUP){

            @Override
            protected void onClick(DataReader dr) {
                int id = dr.readComponentId();
                FlowComponent component = (FlowComponent)TileEntityManager.this.items.get(id);
                boolean moveCluster = dr.readBoolean();
                if (component.getParent() != null) {
                    ComponentMenuGroup.moveComponents(component, component.getParent().getParent(), moveCluster);
                }
            }

            @Override
            public boolean onClick(DataWriter dw) {
                for (FlowComponent item : TileEntityManager.this.items) {
                    if (!item.isBeingMoved()) continue;
                    TileEntityManager.this.justSentServerComponentRemovalPacket = true;
                    dw.writeComponentId(TileEntityManager.this.self, item.getId());
                    dw.writeBoolean(GuiScreen.func_146272_n());
                    item.resetPosition();
                    return true;
                }
                TileEntityManager.this.selectedComponent = TileEntityManager.this.selectedComponent.getParent();
                return false;
            }

            @Override
            public boolean isVisible() {
                return !((TileEntityManager)TileEntityManager.this).field_145850_b.field_72995_K || TileEntityManager.this.selectedComponent != null;
            }

            @Override
            public boolean activateOnRelease() {
                for (FlowComponent item : TileEntityManager.this.items) {
                    if (!item.isBeingMoved()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getMouseOver() {
                for (FlowComponent item : TileEntityManager.this.items) {
                    if (!item.isBeingMoved()) continue;
                    return Localization.EXIT_GROUP_DROP.toString();
                }
                return super.getMouseOver();
            }
        });
    }

    public void removeFlowComponent(int idToRemove) {
        this.removeFlowComponent(idToRemove, this.items);
        if (!this.field_145850_b.field_72995_K) {
            this.removedIds.add(idToRemove);
        } else {
            for (int i = 0; i < this.zLevelRenderingList.size(); ++i) {
                if (this.zLevelRenderingList.get(i).getId() != idToRemove) continue;
                this.zLevelRenderingList.remove(i);
                break;
            }
        }
        this.updateVariables();
    }

    public void removeFlowComponent(int idToRemove, List<FlowComponent> items) {
        int i;
        for (i = items.size() - 1; i >= 0; --i) {
            FlowComponent component = items.get(i);
            if (i == idToRemove) {
                component.setParent(null);
                items.remove(i);
                continue;
            }
            component.updateConnectionIdsAtRemoval(idToRemove);
        }
        if (this.selectedComponent != null && this.selectedComponent.getId() == idToRemove) {
            this.selectedComponent = null;
        }
        for (i = idToRemove; i < items.size(); ++i) {
            items.get(i).decreaseId();
        }
    }

    public void updateVariables() {
        for (Variable variable : this.variables) {
            variable.setDeclaration(null);
        }
        for (FlowComponent item : this.items) {
            if (item.getType() != ComponentType.VARIABLE || item.getConnectionSet() != ConnectionSet.EMPTY) continue;
            int selectedVariable = ((ComponentMenuVariable)item.getMenus().get(0)).getSelectedVariable();
            this.variables[selectedVariable].setDeclaration(item);
        }
    }

    public List<ConnectionBlock> getConnectedInventories() {
        return this.inventories;
    }

    public Connection getCurrentlyConnecting() {
        return this.currentlyConnecting;
    }

    public void setCurrentlyConnecting(Connection currentlyConnecting) {
        this.currentlyConnecting = currentlyConnecting;
    }

    public void func_73660_a() {
        this.justSentServerComponentRemovalPacket = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.timer >= 20) {
                this.timer = 0;
                for (FlowComponent item : this.items) {
                    ComponentMenuInterval componentMenuInterval;
                    int interval;
                    if (item.getType() != ComponentType.TRIGGER || (interval = (componentMenuInterval = (ComponentMenuInterval)item.getMenus().get(2)).getInterval()) == 0) continue;
                    item.setCurrentInterval(item.getCurrentInterval() + 1);
                    if (item.getCurrentInterval() < interval) continue;
                    item.setCurrentInterval(0);
                    EnumSet<ConnectionOption> valid = EnumSet.of(ConnectionOption.INTERVAL);
                    if (item.getConnectionSet() == ConnectionSet.REDSTONE) {
                        redstoneTrigger.onTrigger(item, valid);
                    } else if (item.getConnectionSet() == ConnectionSet.BUD) {
                        budTrigger.onTrigger(item, valid);
                    }
                    this.activateTrigger(item, valid);
                }
            } else {
                ++this.timer;
            }
        }
    }

    public void updateFirst() {
        if (this.firstCommandExecution) {
            this.updateInventories();
            this.updateVariables();
            this.firstCommandExecution = false;
        }
    }

    public void activateTrigger(FlowComponent component, EnumSet<ConnectionOption> validTriggerOutputs) {
        this.updateFirst();
        for (ConnectionBlock inventory : this.inventories) {
            if (!inventory.getTileEntity().func_145837_r()) continue;
            this.updateInventories();
            break;
        }
        new CommandExecutor(this).executeTriggerCommand(component, validTriggerOutputs);
    }

    public void triggerRedstone(TileEntityInput inputTrigger) {
        for (FlowComponent item : this.items) {
            if (item.getType() != ComponentType.TRIGGER || item.getConnectionSet() != ConnectionSet.REDSTONE) continue;
            redstoneTrigger.onRedstoneTrigger(item, inputTrigger);
        }
    }

    public void triggerChat() {
        for (FlowComponent item : this.items) {
            if (item.getType() != ComponentType.TRIGGER || item.getConnectionSet() != ConnectionSet.CHAT) continue;
            this.activateTrigger(item, EnumSet.allOf(ConnectionOption.class));
        }
    }

    public List<Integer> getRemovedIds() {
        return this.removedIds;
    }

    @Override
    public Container getContainer(TileEntity te, InventoryPlayer inv) {
        return new ContainerManager((TileEntityManager)te, inv);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(TileEntity te, InventoryPlayer inv) {
        return new GuiManager((TileEntityManager)te, inv);
    }

    @Override
    public void readAllData(DataReader dr, EntityPlayer player) {
        this.updateInventories();
        int flowControlCount = dr.readComponentId();
        this.getFlowItems().clear();
        this.getZLevelRenderingList().clear();
        for (int i = 0; i < flowControlCount; ++i) {
            this.readAllComponentData(dr);
        }
        for (FlowComponent item : this.items) {
            item.linkParentAfterLoad();
        }
        if (Settings.isAutoCloseGroup()) {
            this.selectedComponent = null;
        } else {
            while (this.selectedComponent != null && !this.findNewSelectedComponent(this.selectedComponent.getId())) {
                this.selectedComponent = this.selectedComponent.getParent();
            }
        }
    }

    public List<FlowComponent> getFlowItems() {
        return this.items;
    }

    public List<FlowComponent> getZLevelRenderingList() {
        return this.zLevelRenderingList;
    }

    public void updateInventories() {
        this.usingUnlimitedInventories = false;
        WorldCoordinate[] oldCoordinates = new WorldCoordinate[this.inventories.size()];
        for (int i = 0; i < oldCoordinates.length; ++i) {
            TileEntity inventory = this.inventories.get(i).getTileEntity();
            oldCoordinates[i] = new WorldCoordinate(inventory.func_174877_v().func_177958_n(), inventory.func_174877_v().func_177956_o(), inventory.func_174877_v().func_177952_p());
            oldCoordinates[i].setTileEntity(inventory);
        }
        ArrayList<WorldCoordinate> visited = new ArrayList<WorldCoordinate>();
        this.inventories.clear();
        PriorityQueue<WorldCoordinate> queue = new PriorityQueue<WorldCoordinate>();
        WorldCoordinate start = new WorldCoordinate(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), 0);
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty()) {
            WorldCoordinate element = (WorldCoordinate)queue.poll();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        WorldCoordinate target;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1 || visited.contains(target = new WorldCoordinate(element.getX() + x, element.getY() + y, element.getZ() + z, element.getDepth() + 1)) || !Settings.isLimitless(this) && this.inventories.size() >= 2048) continue;
                        visited.add(target);
                        TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(target.getX(), target.getY(), target.getZ()));
                        if (te != null) {
                            if (te instanceof TileEntityCluster) {
                                for (TileEntityClusterElement tileEntityClusterElement : ((TileEntityCluster)te).getElements()) {
                                    ((TileEntityCluster)te).setWorldObject(tileEntityClusterElement);
                                    this.addInventory(tileEntityClusterElement, target);
                                }
                            } else {
                                this.addInventory(te, target);
                            }
                        }
                        BlockPos pos = new BlockPos(target.getX(), target.getY(), target.getZ());
                        if (!Settings.isLimitless(this) && element.getDepth() >= 256 || !BlockCable.isCable(this.field_145850_b.func_180495_p(pos).func_177230_c(), this.field_145850_b.func_180495_p(pos).func_177230_c().func_176201_c(this.field_145850_b.func_180495_p(pos)))) continue;
                        queue.add(target);
                    }
                }
            }
        }
        if (this.firstInventoryUpdate) {
            if (this.initialInventoryPositions.size() > 0) {
                oldCoordinates = new WorldCoordinate[this.initialInventoryPositions.size()];
                for (int i = 0; i < oldCoordinates.length; ++i) {
                    BlockPos inventoryPos = this.initialInventoryPositions.get(i);
                    oldCoordinates[i] = new WorldCoordinate(inventoryPos.func_177958_n(), inventoryPos.func_177956_o(), inventoryPos.func_177952_p());
                    TileEntity inventory = this.field_145850_b.func_175625_s(inventoryPos);
                    if (inventory == null) {
                        inventory = new TileEntity(){};
                        inventory.func_174878_a(inventoryPos);
                    }
                    oldCoordinates[i].setTileEntity(inventory);
                }
            } else {
                oldCoordinates = new WorldCoordinate[this.inventories.size()];
                for (int i = 0; i < oldCoordinates.length; ++i) {
                    TileEntity inventory = this.inventories.get(i).getTileEntity();
                    oldCoordinates[i] = new WorldCoordinate(inventory.func_174877_v().func_177958_n(), inventory.func_174877_v().func_177956_o(), inventory.func_174877_v().func_177952_p());
                    oldCoordinates[i].setTileEntity(inventory);
                }
            }
        }
        for (WorldCoordinate oldCoordinate : oldCoordinates) {
            if (!(oldCoordinate.getTileEntity() instanceof ISystemListener)) continue;
            boolean found = false;
            for (ConnectionBlock inventory : this.inventories) {
                if (oldCoordinate.getX() != inventory.getTileEntity().func_174877_v().func_177958_n() || oldCoordinate.getY() != inventory.getTileEntity().func_174877_v().func_177956_o() || oldCoordinate.getZ() != inventory.getTileEntity().func_174877_v().func_177952_p()) continue;
                found = true;
                break;
            }
            if (found) continue;
            ((ISystemListener)oldCoordinate.getTileEntity()).removed(this);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.updateInventorySelection(oldCoordinates);
        } else {
            for (FlowComponent item : this.items) {
                item.setInventoryListDirty(true);
            }
        }
        this.firstInventoryUpdate = false;
    }

    private void addInventory(TileEntity te, WorldCoordinate target) {
        ConnectionBlock connection = new ConnectionBlock(te, target.getDepth());
        boolean isValidConnection = true;
        for (ConnectionBlockType connectionBlockType : ConnectionBlockType.values()) {
            if (!connectionBlockType.isInstance(connection.getTileEntity())) continue;
            isValidConnection = true;
            connection.addType(connectionBlockType);
        }
        if (isValidConnection) {
            connection.setId(this.variables.length + this.inventories.size());
            if (target.getDepth() >= 256 || this.inventories.size() >= 2048) {
                this.usingUnlimitedInventories = true;
            }
            this.inventories.add(connection);
            if (connection.getTileEntity() instanceof ISystemListener) {
                ((ISystemListener)connection.getTileEntity()).added(this);
            }
        }
    }

    private void updateInventorySelection(WorldCoordinate[] oldCoordinates) {
        for (FlowComponent item : this.items) {
            for (ComponentMenu menu : item.getMenus()) {
                if (!(menu instanceof ComponentMenuContainer)) continue;
                ComponentMenuContainer menuInventory = (ComponentMenuContainer)menu;
                List<Integer> oldSelection = menuInventory.getSelectedInventories();
                menuInventory.setSelectedInventories(this.getNewSelection(oldCoordinates, oldSelection, true));
            }
        }
        for (Variable variable : this.variables) {
            variable.setContainers(this.getNewSelection(oldCoordinates, variable.getContainers(), false));
        }
    }

    private List<Integer> getNewSelection(WorldCoordinate[] oldCoordinates, List<Integer> oldSelection, boolean hasVariables) {
        ArrayList<Integer> newSelection = new ArrayList<Integer>();
        block0: for (int i = 0; i < oldSelection.size(); ++i) {
            int selection = oldSelection.get(i);
            if (hasVariables && selection >= 0 && selection < 16) {
                newSelection.add(selection);
                continue;
            }
            if (hasVariables) {
                selection -= this.variables.length;
            }
            if (selection < 0 || selection >= oldCoordinates.length) continue;
            WorldCoordinate coordinate = oldCoordinates[selection];
            for (int j = 0; j < this.inventories.size(); ++j) {
                TileEntity inventory = this.inventories.get(j).getTileEntity();
                if (coordinate.getX() != inventory.func_174877_v().func_177958_n() || coordinate.getY() != inventory.func_174877_v().func_177956_o() || coordinate.getZ() != inventory.func_174877_v().func_177952_p() || !inventory.getClass().equals(coordinate.getTileEntity().getClass())) continue;
                int id = j + (hasVariables ? this.variables.length : 0);
                if (newSelection.contains(id)) continue block0;
                newSelection.add(id);
                continue block0;
            }
        }
        return newSelection;
    }

    private boolean findNewSelectedComponent(int id) {
        for (FlowComponent item : this.items) {
            if (item.getId() != id) continue;
            this.selectedComponent = item;
            return true;
        }
        return false;
    }

    private void readAllComponentData(DataReader dr) {
        int x = dr.readData(DataBitHelper.FLOW_CONTROL_X);
        int y = dr.readData(DataBitHelper.FLOW_CONTROL_Y);
        int id = dr.readData(DataBitHelper.FLOW_CONTROL_TYPE_ID);
        FlowComponent flowComponent = new FlowComponent(this, x, y, ComponentType.getTypeFromId(id));
        flowComponent.setComponentName(dr.readString(DataBitHelper.NAME_LENGTH));
        boolean hasParent = dr.readBoolean();
        if (hasParent) {
            flowComponent.setParentLoadId(dr.readComponentId());
        } else {
            flowComponent.setParentLoadId(-1);
        }
        for (ComponentMenu menu : flowComponent.getMenus()) {
            menu.readData(dr);
        }
        flowComponent.clearConnections();
        for (int i = 0; i < flowComponent.getConnectionSet().getConnections().length; ++i) {
            boolean hasConnection = dr.readBoolean();
            if (!hasConnection) continue;
            Connection connection = new Connection(dr.readComponentId(), dr.readData(DataBitHelper.CONNECTION_ID));
            flowComponent.setConnection(i, connection);
            int length = dr.readData(DataBitHelper.NODE_ID);
            for (int j = 0; j < length; ++j) {
                connection.getNodes().add(new Point(dr.readData(DataBitHelper.FLOW_CONTROL_X), dr.readData(DataBitHelper.FLOW_CONTROL_Y)));
            }
        }
        this.getFlowItems().add(flowComponent);
        this.getZLevelRenderingList().add(0, flowComponent);
        this.updateVariables();
    }

    @Override
    public void readUpdatedData(DataReader dr, EntityPlayer player) {
        boolean isNew;
        if (!this.field_145850_b.field_72995_K && dr.readBoolean()) {
            boolean val = dr.readBoolean();
            if ((val || !this.isUsingUnlimitedStuff()) && player.field_71075_bZ.field_75098_d) {
                Settings.setLimitless(this, val);
            }
            return;
        }
        boolean bl = isNew = this.field_145850_b.field_72995_K && dr.readBoolean();
        if (isNew) {
            this.readAllComponentData(dr);
            this.items.get(this.items.size() - 1).linkParentAfterLoad();
        } else {
            boolean isSpecificComponent = dr.readBoolean();
            if (isSpecificComponent) {
                IComponentNetworkReader nr = this.getNetworkReaderForComponentPacket(dr, this);
                if (nr != null) {
                    nr.readNetworkComponent(dr);
                }
            } else {
                this.readGenericData(dr);
            }
        }
    }

    public void readGenericData(DataReader dr) {
        if (this.field_145850_b.field_72995_K) {
            if (dr.readBoolean()) {
                this.updateInventories();
            } else {
                this.removeFlowComponent(dr.readComponentId());
            }
        } else {
            Button button;
            int buttonId = dr.readData(DataBitHelper.GUI_BUTTON_ID);
            if (buttonId >= 0 && buttonId < this.buttons.size() && (button = this.buttons.get(buttonId)).isVisible()) {
                button.onClick(dr);
            }
        }
    }

    private boolean isUsingUnlimitedStuff() {
        return this.items.size() > 511 || this.usingUnlimitedInventories;
    }

    @Override
    public void writeAllData(DataWriter dw) {
        dw.writeComponentId(this, this.getFlowItems().size());
        for (FlowComponent flowComponent : this.getFlowItems()) {
            PacketHandler.writeAllComponentData(dw, flowComponent);
        }
    }

    private IComponentNetworkReader getNetworkReaderForComponentPacket(DataReader dr, TileEntityManager jam) {
        int componentId = dr.readComponentId();
        if (componentId >= 0 && componentId < jam.getFlowItems().size()) {
            FlowComponent component = jam.getFlowItems().get(componentId);
            if (dr.readBoolean()) {
                int menuId = dr.readData(DataBitHelper.FLOW_CONTROL_MENU_COUNT);
                if (menuId >= 0 && menuId < component.getMenus().size()) {
                    return component.getMenus().get(menuId);
                }
            } else {
                return component;
            }
        }
        return null;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public void triggerBUD(TileEntityBUD tileEntityBUD) {
        for (FlowComponent item : this.items) {
            if (item.getType() != ComponentType.TRIGGER || item.getConnectionSet() != ConnectionSet.BUD) continue;
            budTrigger.triggerBUD(item, tileEntityBUD);
        }
    }

    public FlowComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public void setSelectedComponent(FlowComponent selectedComponent) {
        this.selectedComponent = selectedComponent;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readContentFromNBT(nbtTagCompound, false);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeContentToNBT(compound, false);
        return super.func_189515_b(compound);
    }

    public void writeContentToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74774_a("ProtocolVersion", (byte)14);
        nbtTagCompound.func_74774_a(NBT_TIMER, (byte)this.timer);
        NBTTagList components = new NBTTagList();
        for (FlowComponent flowComponent : this.items) {
            NBTTagCompound component = new NBTTagCompound();
            flowComponent.writeToNBT(component, pickup);
            components.func_74742_a((NBTBase)component);
        }
        nbtTagCompound.func_74782_a(NBT_COMPONENTS, (NBTBase)components);
        NBTTagList variablesTag = new NBTTagList();
        for (Variable variable : this.variables) {
            NBTTagCompound variableTag = new NBTTagCompound();
            variable.writeToNBT(variableTag);
            variablesTag.func_74742_a((NBTBase)variableTag);
        }
        nbtTagCompound.func_74782_a(NBT_VARIABLES, (NBTBase)variablesTag);
        NBTTagList nBTTagList = new NBTTagList();
        for (ConnectionBlock connectionBlock : this.inventories) {
            BlockPos pos = connectionBlock.getTileEntity().func_174877_v();
            nBTTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        nbtTagCompound.func_74782_a(NBT_INVENTORY_POSITIONS, (NBTBase)nBTTagList);
    }

    public void readContentFromNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        byte version = nbtTagCompound.func_74771_c("ProtocolVersion");
        this.timer = nbtTagCompound.func_74771_c(NBT_TIMER);
        NBTTagList components = nbtTagCompound.func_150295_c(NBT_COMPONENTS, 10);
        for (int i = 0; i < components.func_74745_c(); ++i) {
            NBTTagCompound component = components.func_150305_b(i);
            this.items.add(FlowComponent.readFromNBT(this, component, version, pickup));
        }
        if (version == 8) {
            for (FlowComponent item : this.items) {
                for (int i = 0; i < item.getConnectionSet().getConnections().length; ++i) {
                    Connection connection = item.getConnection(i);
                    if (connection == null) continue;
                    if (connection.getComponentId() < 0 || connection.getComponentId() >= this.items.size()) {
                        item.setConnection(i, null);
                        continue;
                    }
                    FlowComponent otherItem = this.getFlowItems().get(connection.getComponentId());
                    Connection otherConnection = otherItem.getConnection(connection.getConnectionId());
                    if (otherConnection != null && otherConnection.getComponentId() >= 0 && otherConnection.getComponentId() < this.items.size()) continue;
                    otherItem.setConnection(connection.getConnectionId(), new Connection(item.getId(), i));
                }
            }
        }
        for (FlowComponent item : this.items) {
            item.linkParentAfterLoad();
        }
        NBTTagList variablesTag = nbtTagCompound.func_150295_c(NBT_VARIABLES, 10);
        for (int i = 0; i < variablesTag.func_74745_c(); ++i) {
            NBTTagCompound variableTag = variablesTag.func_150305_b(i);
            this.variables[i].readFromNBT(variableTag);
        }
        if (version >= 14) {
            this.initialInventoryPositions.clear();
            NBTTagList inventoryPositionsTag = nbtTagCompound.func_150295_c(NBT_INVENTORY_POSITIONS, 10);
            for (int i = 0; i < inventoryPositionsTag.func_74745_c(); ++i) {
                BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)inventoryPositionsTag.func_150305_b(i));
                this.initialInventoryPositions.add(pos);
            }
        }
    }

    private class ButtonCreate
    extends Button {
        private ComponentType type;

        protected ButtonCreate(ComponentType type) {
            super(type.getLongUnLocalizedName());
            this.type = type;
        }

        @Override
        protected void onClick(DataReader dr) {
            if (Settings.isLimitless(TileEntityManager.this.self) || TileEntityManager.this.getFlowItems().size() < 511) {
                boolean isOutput;
                FlowComponent component = new FlowComponent(TileEntityManager.this.self, 50, 50, this.type);
                boolean hasParent = dr.readBoolean();
                if (hasParent) {
                    component.setParent((FlowComponent)TileEntityManager.this.items.get(dr.readComponentId()));
                }
                boolean autoSide = dr.readBoolean();
                boolean autoBlackList = dr.readBoolean();
                boolean moveFirst = dr.readBoolean();
                boolean isInput = this.type == ComponentType.INPUT || this.type == ComponentType.FLUID_INPUT;
                boolean bl = isOutput = this.type == ComponentType.OUTPUT || this.type == ComponentType.FLUID_OUTPUT;
                if (autoSide) {
                    for (ComponentMenu componentMenu : component.getMenus()) {
                        if (!(componentMenu instanceof ComponentMenuTarget)) continue;
                        ((ComponentMenuTarget)componentMenu).setActive(isOutput ? 1 : 0);
                    }
                }
                if (autoBlackList && isInput) {
                    for (ComponentMenu componentMenu : component.getMenus()) {
                        if (!(componentMenu instanceof ComponentMenuStuff)) continue;
                        ((ComponentMenuStuff)componentMenu).setBlackList();
                    }
                }
                if (this.type == ComponentType.AUTO_CRAFTING) {
                    for (ComponentMenu componentMenu : component.getMenus()) {
                        if (!(componentMenu instanceof ComponentMenuCraftingPriority)) continue;
                        ((ComponentMenuCraftingPriority)componentMenu).setPrioritizeCrafting(!moveFirst);
                    }
                }
                TileEntityManager.this.getFlowItems().add(component);
            }
        }

        @Override
        public boolean onClick(DataWriter dw) {
            if (TileEntityManager.this.selectedComponent != null) {
                dw.writeBoolean(true);
                dw.writeComponentId(TileEntityManager.this.self, TileEntityManager.this.selectedComponent.getId());
            } else {
                dw.writeBoolean(false);
            }
            dw.writeBoolean(Settings.isAutoSide());
            dw.writeBoolean(Settings.isAutoBlacklist());
            dw.writeBoolean(Settings.isPriorityMoveFirst());
            return true;
        }

        @Override
        public String getMouseOver() {
            if (!Settings.isLimitless(TileEntityManager.this.self) && TileEntityManager.this.getFlowItems().size() == 511) {
                return Localization.MAXIMUM_COMPONENT_ERROR.toString();
            }
            return Localization.CREATE_COMMAND.toString() + " " + super.getMouseOver();
        }
    }

    public abstract class Button {
        private Localization mouseOver;
        private int x;
        private int y;

        protected Button(Localization mouseOver) {
            int id = TileEntityManager.this.buttons.size();
            this.x = 5 + id / 13 * 18;
            this.y = 5 + id % 13 * 18;
            this.mouseOver = mouseOver;
        }

        protected abstract void onClick(DataReader var1);

        public abstract boolean onClick(DataWriter var1);

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String getMouseOver() {
            return this.mouseOver.toString();
        }

        public boolean activateOnRelease() {
            return false;
        }

        public boolean isVisible() {
            return true;
        }
    }
}

