/*
 * Decompiled with CFR 0.152.
 */
package tinkersoc.smeltery;

import java.util.HashMap;
import li.cil.oc.api.API;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import tinkersoc.AbstractTinkersEnvironment;

public class EnvironmentSmeltery
extends AbstractTinkersEnvironment<TileSmeltery> {
    public EnvironmentSmeltery(TileSmeltery smeltery) {
        super("smeltery", smeltery);
    }

    @Callback(doc="function():table - Get the fluids contained in the smeltery")
    public Object[] getContainedFluids(Context context, Arguments arguments) {
        return ((TileSmeltery)this.tile).getTank().getFluids().toArray();
    }

    @Callback(doc="function():table - Get information on the smeltery's current fuel")
    public Object[] getFuelInfo(Context context, Arguments arguments) {
        final FluidStack stack = ((TileSmeltery)this.tile).currentFuel;
        return new Object[]{new HashMap<String, Object>(){
            {
                this.put("fluid", stack);
                this.put("heat", stack.getFluid().getTemperature());
                this.put("maxCap", stack.amount);
            }
        }};
    }

    @Callback(doc="function():int - Gets the amount of fuel in the smeltery")
    public Object[] getFuelLevel(Context context, Arguments arguments) {
        return new Object[]{((TileSmeltery)this.tile).currentFuel.amount};
    }

    @Callback(doc="function([index:int]):int - Gets the smeltery temperature or the temperature of an item being smelted")
    public Object[] getTemperature(Context context, Arguments arguments) {
        if (arguments.count() == 0) {
            return new Object[]{((TileSmeltery)this.tile).getTemperature()};
        }
        return new Object[]{((TileSmeltery)this.tile).getTemperature(arguments.checkInteger(0))};
    }

    @Callback(doc="function(index:int) - Returns whether the item in the specified slot can be heated")
    public Object[] canHeat(Context context, Arguments arguments) {
        return new Object[]{((TileSmeltery)this.tile).canHeat(arguments.checkInteger(0))};
    }

    @Callback(doc="function():int - Gets the number of smelting slots the smeltery has")
    public Object[] getInventorySize(Context context, Arguments arguments) {
        return new Object[]{((TileSmeltery)this.tile).func_70302_i_()};
    }

    @Callback(doc="function(index:int):int - Gets the required temperature for the item in the specified slot")
    public Object[] getTempRequired(Context context, Arguments arguments) {
        return new Object[]{((TileSmeltery)this.tile).getTempRequired(arguments.checkInteger(0))};
    }

    @Callback(doc="function():boolean - Gets whether the smeltery has fuel")
    public Object[] hasFuel(Context context, Arguments arguments) {
        return new Object[]{((TileSmeltery)this.tile).hasFuel()};
    }

    @Callback(doc="function():boolean - Gets whether the smeltery is empty (has no fluids)")
    public Object[] isEmpty(Context context, Arguments arguments) {
        return new Object[]{((TileSmeltery)this.tile).func_191420_l()};
    }

    @Callback(doc="function():int - Gets the total fluid capacity of the smeltery")
    public Object[] getCapacity(Context context, Arguments arguments) {
        return new Object[]{((TileSmeltery)this.tile).getTank().getCapacity()};
    }

    @Callback(doc="function():int - Gets the total amount of all fluids in the smeltery")
    public Object[] getFillLevel(Context context, Arguments arguments) {
        return new Object[]{((TileSmeltery)this.tile).getTank().getFluidAmount()};
    }

    @Callback(doc="function(index:integer):boolean - Moves the fluid at the specified index to the bottom")
    public Object[] moveFluidToBottom(Context context, Arguments arguments) {
        int idx = arguments.checkInteger(0);
        if (idx < 1 || idx > ((TileSmeltery)this.tile).getTank().getFluids().size()) {
            return new Object[]{false, "Invalid index"};
        }
        ((TileSmeltery)this.tile).getTank().moveFluidToBottom(idx - 1);
        return new Object[]{true};
    }

    @Callback(doc="function(index:int):table - Gets the stack in the specified slot")
    public Object[] getStackInSlot(Context context, Arguments arguments) {
        if (!API.config.getBoolean("misc.allowItemStackInspection")) {
            return new Object[]{null, "ItemStack inspection disabled in OC config"};
        }
        int slot = arguments.checkInteger(0);
        if (slot < 1 || slot > ((TileSmeltery)this.tile).func_70302_i_()) {
            return new Object[]{null, "Invalid slot"};
        }
        ItemStack stack = ((TileSmeltery)this.tile).getItemHandler().getStackInSlot(--slot);
        if (stack.func_190926_b()) {
            return new Object[]{null, "No item"};
        }
        return new Object[]{stack};
    }

    @Callback(doc="function(index:int):number - Gets the heating progress of the item in the specified slot")
    public Object[] getHeatingProgress(Context context, Arguments arguments) {
        return new Object[]{Float.valueOf(((TileSmeltery)this.tile).getHeatingProgress(arguments.checkInteger(0)))};
    }
}

