/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSyncConfig
implements IMessage {
    private NBTTagCompound tagCompound;

    public PacketSyncConfig() {
        this(new NBTTagCompound());
    }

    public PacketSyncConfig(NBTTagCompound tagCompound) {
        this.tagCompound = tagCompound;
    }

    public void fromBytes(ByteBuf buf) {
        this.tagCompound = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tagCompound);
    }

    public NBTTagCompound getTagCompound() {
        return this.tagCompound;
    }

    public static class Handler
    implements IMessageHandler<PacketSyncConfig, IMessage> {
        public IMessage onMessage(PacketSyncConfig message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> {
                NBTTagCompound compound = message.getTagCompound();
                BuildingGadgets.logger.info("Received SyncedConfig from Server.");
                SyncedConfig.onReadSynchronisation(compound);
            });
            return null;
        }
    }
}

