/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tickcentral.asm;

import com.github.terminatornl.tickcentral.TickCentral;
import com.github.terminatornl.tickcentral.api.ClassDebugger;
import com.github.terminatornl.tickcentral.asm.Utilities;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class HubAPITransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        try {
            if (basicClass == null || !transformedName.equals("com.github.terminatornl.tickcentral.api.TickHub")) {
                return basicClass;
            }
            ClassReader reader = new ClassReader(basicClass);
            ClassNode classNode = new ClassNode();
            reader.accept((ClassVisitor)classNode, 0);
            for (MethodNode method : classNode.methods) {
                switch (method.name) {
                    case "trueRandomTick": {
                        Utilities.convertAllInstructions("TickCentral_TrueRandomTick", method.instructions);
                        break;
                    }
                    case "trueUpdateTick": {
                        Utilities.convertAllInstructions("TickCentral_TrueUpdateTick", method.instructions);
                        break;
                    }
                    case "trueUpdate": {
                        Utilities.convertAllInstructions("TickCentral_TrueITickableUpdate", method.instructions);
                        break;
                    }
                    case "trueOnUpdate": {
                        Utilities.convertAllInstructions("TickCentral_TrueOnUpdateTick", method.instructions);
                    }
                }
            }
            return ClassDebugger.WriteClass(classNode, transformedName);
        }
        catch (Throwable e) {
            TickCentral.LOGGER.fatal("An error has occurred", e);
            FMLCommonHandler.instance().exitJava(1, false);
            throw new RuntimeException(e);
        }
    }
}

