/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.control;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import wanion.lib.common.Dependencies;
import wanion.lib.common.IController;
import wanion.lib.common.ICopyable;
import wanion.lib.common.WContainer;
import wanion.lib.common.control.IControl;
import wanion.lib.network.NetworkHelper;

public final class ControlController
extends Dependencies<IControl<?>>
implements IController<ControlController, IControl<?>>,
ICopyable<ControlController> {
    private final IInventory inventory;

    public ControlController(@Nonnull IInventory inventory) {
        this.inventory = inventory;
    }

    public ControlController(@Nonnull IInventory inventory, IControl<?> ... dependencies) {
        super(dependencies);
        this.inventory = inventory;
    }

    public ControlController(@Nonnull IInventory inventory, @Nonnull Collection<IControl<?>> dependencies) {
        super(dependencies);
        this.inventory = inventory;
    }

    public ControlController(@Nonnull IInventory inventory, @Nonnull ControlController controlController) {
        super(controlController);
        this.inventory = inventory;
    }

    @Override
    @Nonnull
    public List<IControl<?>> compareContents(@Nonnull ControlController otherController) {
        return super.compareContents(otherController);
    }

    @Override
    public void addListener(int windowId, @Nonnull WContainer<?> wContainer, @Nonnull EntityPlayerMP entityPlayerMP) {
        NetworkHelper.addControlListener(windowId, wContainer, entityPlayerMP);
    }

    @Override
    public void detectAndSendChanges(int windowId, @Nonnull WContainer<?> wContainer) {
        NetworkHelper.detectAndSendControlChanges(windowId, wContainer);
    }

    @Override
    @Nonnull
    public NBTTagCompound writeNBT() {
        NBTTagCompound controlNBT = new NBTTagCompound();
        NBTTagList controlTagList = new NBTTagList();
        controlNBT.func_74782_a("control", (NBTBase)controlTagList);
        this.getInstances().forEach(control -> controlTagList.func_74742_a((NBTBase)control.writeNBT()));
        return controlNBT;
    }

    @Override
    public void afterWriteNBT(@Nonnull NBTTagCompound smartNBT) {
        NBTTagList controlTagList = smartNBT.func_150295_c("control", 10);
        if (controlTagList.func_82582_d()) {
            return;
        }
        this.getInstances().forEach(control -> {
            for (int i = 0; i < controlTagList.func_74745_c(); ++i) {
                control.afterWriteNBT(controlTagList.func_150305_b(i));
            }
        });
    }

    @Override
    public void readNBT(@Nonnull NBTTagCompound smartNBT) {
        NBTTagList controlTagList = smartNBT.func_150295_c("control", 10);
        if (controlTagList.func_82582_d()) {
            return;
        }
        this.getInstances().forEach(control -> {
            for (int i = 0; i < controlTagList.func_74745_c(); ++i) {
                control.readNBT(controlTagList.func_150305_b(i));
            }
        });
        this.inventory.func_70296_d();
    }

    @Override
    @Nonnull
    public ControlController copy() {
        return new ControlController(this.inventory, this.getInstances().stream().map(ICopyable::copy).collect(Collectors.toList()));
    }
}

