/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.block.state;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;

public class VirtualState {
    private final Map<IProperty<?>, Comparable<?>> props = new HashMap();
    @Nullable
    private Integer hashCode = null;

    private VirtualState() {
    }

    public Map<String, String> getSerializedProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.props.forEach((p, v) -> result.put(p.func_177701_a(), p.func_177702_a(v)));
        return result;
    }

    public <T extends Comparable<T>> T get(IProperty<T> prop) {
        return (T)this.props.get(prop);
    }

    public boolean matches(IBlockState state) {
        for (Map.Entry<IProperty<?>, Comparable<?>> prop : this.props.entrySet()) {
            if (state.func_177229_b(prop.getKey()).equals(prop.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode == null ? (this.hashCode = Integer.valueOf(this.props.hashCode())) : this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof VirtualState && this.props.equals(((VirtualState)obj).props);
    }

    public IBlockState synthesize(BlockStateContainer container) {
        IBlockState state = container.func_177621_b();
        for (Map.Entry<IProperty<?>, Comparable<?>> prop : this.props.entrySet()) {
            state = state.func_177226_a(prop.getKey(), prop.getValue());
        }
        return state;
    }

    private Stream<VirtualState> cartesian(IProperty<?> prop) {
        return prop.func_177700_c().stream().map(v -> this.compose(prop, (Comparable)v));
    }

    private VirtualState compose(IProperty<?> prop, Comparable value) {
        VirtualState result = new VirtualState();
        result.props.putAll(this.props);
        result.props.put(prop, value);
        return result;
    }

    private VirtualState compose(VirtualState other) {
        VirtualState result = new VirtualState();
        result.props.putAll(this.props);
        result.props.putAll(other.props);
        return result;
    }

    public static List<VirtualState> cartesian(List<IProperty<?>> props) {
        return props.stream().reduce(Lists.newArrayList((Object[])new VirtualState[]{new VirtualState()}), (l, p) -> l.stream().flatMap(s -> s.cartesian((IProperty<?>)p)).collect(Collectors.toList()), (a, b) -> a.stream().flatMap(s -> b.stream().map(s::compose)).collect(Collectors.toList()));
    }
}

