/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.event;

import io.github.phantamanta44.libnine.component.multiblock.IMultiBlockUnit;
import io.github.phantamanta44.libnine.util.render.RenderUtils;
import io.github.phantamanta44.libnine.util.world.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MultiBlockDebugRenderHandler {
    private static final int RADIUS = 7;
    private static final int RADIUS_SQ = 49;
    private static boolean enabled = false;
    private final Minecraft mc = Minecraft.func_71410_x();

    public static void toggle() {
        enabled = !enabled;
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        if (!enabled) {
            return;
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        Vec3d plPos = RenderUtils.getInterpPos((Entity)this.mc.field_71439_g, event.getPartialTicks());
        BlockPos plCoords = this.mc.field_71439_g.func_180425_c();
        double offX = plPos.field_72450_a - (double)plCoords.func_177958_n();
        double offY = plPos.field_72448_b - (double)plCoords.func_177956_o();
        double offZ = plPos.field_72449_c - (double)plCoords.func_177952_p();
        buf.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 8; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    TileEntity tile;
                    BlockPos blCoords = plCoords.func_177982_a(x, y, z);
                    double distSq = WorldUtils.getBlockCenter(blCoords).func_186679_c(plPos.field_72450_a, plPos.field_72448_b, plPos.field_72449_c);
                    if (!(distSq < 49.0) || !((tile = this.mc.field_71441_e.func_175625_s(blCoords)) instanceof IMultiBlockUnit)) continue;
                    for (EnumFacing dir : ((IMultiBlockUnit)tile).getMultiBlockConnection().getEmittingDirs()) {
                        double blkX = (double)x - offX + 0.5;
                        double blkY = (double)y - offY + 0.5;
                        double blkZ = (double)z - offZ + 0.5;
                        buf.func_181662_b(blkX, blkY, blkZ).func_181675_d();
                        buf.func_181662_b(blkX + (double)dir.func_82601_c(), blkY + (double)dir.func_96559_d(), blkZ + (double)dir.func_82599_e()).func_181675_d();
                    }
                }
            }
        }
        tess.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
    }
}

