/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.gui.component.impl;

import io.github.phantamanta44.libnine.client.gui.component.GuiComponent;
import io.github.phantamanta44.libnine.util.render.FluidRenderUtils;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class GuiComponentFluidTank
extends GuiComponent {
    private final Supplier<FluidTankInfo> tankGetter;

    public GuiComponentFluidTank(int x, int y, int width, int height, Supplier<FluidTankInfo> tankGetter) {
        super(x, y, width, height);
        this.tankGetter = tankGetter;
    }

    public GuiComponentFluidTank(int x, int y, int width, int height, IFluidTank tank) {
        this(x, y, width, height, () -> ((IFluidTank)tank).getInfo());
    }

    @Override
    public void render(float partialTicks, int mX, int mY, boolean mouseOver) {
        FluidTankInfo tank = this.tankGetter.get();
        if (tank.fluid != null && tank.fluid.amount > 0) {
            FluidRenderUtils.renderFluidIntoGuiCleanly(this.x, this.y, 16, 16, tank.fluid, tank.capacity);
        }
    }

    @Override
    public void renderTooltip(float partialTicks, int mX, int mY) {
        FluidTankInfo tank = this.tankGetter.get();
        if (tank.fluid != null && tank.fluid.amount > 0) {
            this.drawTooltip(Arrays.asList(tank.fluid.getLocalizedName(), TextFormatting.GRAY + String.format("%,d / %,d mB", tank.fluid.amount, tank.capacity)), mX, mY);
        } else {
            this.drawTooltip(Arrays.asList(I18n.func_135052_a((String)"libnine.info.empty", (Object[])new Object[0]), TextFormatting.GRAY + String.format("0 / %,d mB", tank.capacity)), mX, mY);
        }
    }
}

