/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.network;

import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.tile.L9TileEntity;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketServerSyncTileEntity
implements IMessage {
    private int dimension;
    private BlockPos pos;
    private byte[] data;

    public PacketServerSyncTileEntity() {
    }

    public PacketServerSyncTileEntity(L9TileEntity tile) {
        this.dimension = tile.func_145831_w().field_73011_w.getDimension();
        this.pos = tile.func_174877_v();
        ByteUtils.Writer writer = ByteUtils.writer();
        tile.serBytes(writer);
        this.data = writer.toArray();
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        this.data = new byte[buf.readableBytes()];
        buf.readBytes(this.data);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBytes(this.data);
    }

    public static class Handler
    implements IMessageHandler<PacketServerSyncTileEntity, IMessage> {
        @Nullable
        public IMessage onMessage(PacketServerSyncTileEntity message, MessageContext ctx) {
            World world = LibNine.PROXY.getDimensionWorld(message.dimension);
            if (world != null) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    TileEntity tile = world.func_175625_s(message.pos);
                    if (tile instanceof L9TileEntity) {
                        ((L9TileEntity)tile).onTileSyncPacket(ByteUtils.reader(message.data));
                    } else {
                        LibNine.LOGGER.warn("No tile exists for sync packet at pos {}", (Object)message.pos);
                    }
                });
            }
            return null;
        }
    }
}

