/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.math;

public class RunningAverage {
    private final int[] samples;
    private int pointer;

    public RunningAverage(int sampleSize) {
        this.samples = new int[sampleSize];
        this.pointer = 0;
    }

    public int calculateAndCycle(int newSample) {
        int result = 0;
        for (int sample : this.samples) {
            result += sample;
        }
        this.pointer = (this.pointer + 1) % this.samples.length;
        this.samples[this.pointer] = newSample;
        return Math.round((float)result / (float)this.samples.length);
    }
}

