/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.tuple;

import io.github.phantamanta44.libnine.util.function.ITriConsumer;
import io.github.phantamanta44.libnine.util.function.ITriFunction;
import io.github.phantamanta44.libnine.util.tuple.IPair;

public interface ITriple<A, B, C> {
    public A getA();

    public B getB();

    public C getC();

    default public IPair<B, C> truncateA() {
        return IPair.of(this.getB(), this.getC());
    }

    default public IPair<A, C> truncateB() {
        return IPair.of(this.getA(), this.getC());
    }

    default public IPair<A, B> truncateC() {
        return IPair.of(this.getA(), this.getB());
    }

    default public void sprexec(ITriConsumer<A, B, C> executor) {
        executor.accept(this.getA(), this.getB(), this.getC());
    }

    default public <T> T sprcall(ITriFunction<A, B, C, T> executor) {
        return executor.apply(this.getA(), this.getB(), this.getC());
    }

    public static <A, B, C> ITriple<A, B, C> of(A a, B b, C c) {
        return new Impl(a, b, c);
    }

    public static class Impl<A, B, C>
    implements ITriple<A, B, C> {
        private final A a;
        private final B b;
        private final C c;

        private Impl(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        @Override
        public A getA() {
            return this.a;
        }

        @Override
        public B getB() {
            return this.b;
        }

        @Override
        public C getC() {
            return this.c;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ITriple)) {
                return false;
            }
            ITriple tri = (ITriple)o;
            return tri.getA().equals(this.a) && tri.getB().equals(this.b) && tri.getC().equals(this.c);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.c.hashCode();
        }
    }
}

