/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.world;

import com.google.common.collect.ImmutableList;
import io.github.phantamanta44.libnine.util.format.ILocalizable;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;

public enum RedstoneBehaviour implements ILocalizable
{
    IGNORED{

        @Override
        public boolean canWork(boolean powered) {
            return true;
        }

        @Override
        public boolean canWork(WorldBlockPos pos) {
            return true;
        }

        @Override
        public String getTranslationKey() {
            return "libnine.info.redstone_behaviour.ignored";
        }
    }
    ,
    DIRECT{

        @Override
        public boolean canWork(boolean powered) {
            return powered;
        }

        @Override
        public boolean canWork(WorldBlockPos pos) {
            return pos.getWorld().func_175640_z(pos.getPos());
        }

        @Override
        public String getTranslationKey() {
            return "libnine.info.redstone_behaviour.direct";
        }
    }
    ,
    INVERTED{

        @Override
        public boolean canWork(boolean powered) {
            return !powered;
        }

        @Override
        public boolean canWork(WorldBlockPos pos) {
            return !pos.getWorld().func_175640_z(pos.getPos());
        }

        @Override
        public String getTranslationKey() {
            return "libnine.info.redstone_behaviour.inverted";
        }
    };

    public static final ImmutableList<RedstoneBehaviour> VALUES;

    public abstract boolean canWork(boolean var1);

    public abstract boolean canWork(WorldBlockPos var1);

    @Override
    public abstract String getTranslationKey();

    static {
        VALUES = ImmutableList.copyOf((Object[])RedstoneBehaviour.values());
    }
}

